% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param_info.R
\name{get_param_info}
\alias{get_param_info}
\title{Finding parameters information using partial search words}
\usage{
get_param_info(
  param = NULL,
  file = NULL,
  formalism = NULL,
  keyword = NULL,
  stics_version = "latest",
  file_path = lifecycle::deprecated(),
  parameter = lifecycle::deprecated(),
  version = lifecycle::deprecated()
)
}
\arguments{
\item{param}{Vector of parameter names (or partial names). Optional, if not
provided, the function returns information for all parameters}

\item{file}{Vector of xml file paths. Optional, if not provided, the function
searches information in all standard XML files.}

\item{formalism}{Optional, formalism name or partial name, or a vector of}

\item{keyword}{Optional, strings or a vector of to be used for searching
in parameters data (i.e.: parameters names, formalisms description,
file names or part to which parameters are attached to)}

\item{stics_version}{Name of the STICS version. Optional,
can be used to search parameters information relative to a specific
STICS version. By default the latest version returned
by \code{get_stics_versions_compat()} is used.}

\item{file_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{file_path} is no
longer supported, use \code{file} instead.}

\item{parameter}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{parameter} is no
longer supported, use \code{param} instead.}

\item{version}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version} is no
longer supported, use \code{stics_version} instead.}
}
\value{
A data.frame containing parameters names,
their file name origin, their bounds and the formalism they belong to. The
data.frame has the model version as attribute.
}
\description{
Finding parameters information using partial search words
}
\details{
parameter and formalism may be both set or only one of them, but
none of them can be if keyword argument is used.
}
\examples{
\dontrun{
get_param_info(param = "albedo")
get_param_info(param = "albedo", file = "/path/to/file.xml")

get_param_info(param = "albedo", formalism = "special")

get_param_info(param = "albedo", stics_version = "V9.0")

get_param_info(param = c("alb", "lat"))

get_param_info(keyword = "tec")

# Get the model version afterward:
params <- get_param_info(param = "albedo")
attr(params, "version")
}

}
