% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_workspace_xml.R
\name{upgrade_workspace_xml}
\alias{upgrade_workspace_xml}
\title{Upgrading XML files of a JavaSTICS workspace directory
to a newer STICS version format}
\usage{
upgrade_workspace_xml(
  workspace,
  javastics,
  out_dir,
  stics_version = "V9.2",
  target_version = "V10.0",
  plant = FALSE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{workspace}{Path of a JavaSTICS workspace}

\item{javastics}{Path of JavaSTICS}

\item{out_dir}{Output directory of the generated files}

\item{stics_version}{Name of the STICS version (VX.Y format)}

\item{target_version}{Name of the STICS version to upgrade files
to  (VX.Y format)}

\item{plant}{logical (optional), TRUE for upgrading plant files if a "plant"
sub-directory of workspace exists, FALSE otherwise}

\item{overwrite}{logical (optional),
TRUE for overwriting files if they exist, FALSE otherwise}

\item{...}{Additional input arguments}
}
\value{
None
}
\description{
Upgrading XML files of a JavaSTICS workspace directory
to a newer STICS version format
}
\details{
\itemize{
\item See SticsRFiles::get_stics_versions_compat() for listing versions
\item If general parameters files exist in \code{workspace}, they are also upgraded.
In that case, residues parameters values are kept and might not be adapted
to the target model version.
\item Weather data and observations files are fully copied to \code{out_dir}
}
}
\examples{
\dontrun{
upgrade_workspace_xml(
  workspace = "/path/to/JavaSTICS/workspace",
  javastics = "/path/to/JavaSTICS/folder",
  out_dir = "/path/to/an/output/directory"
)
}
}
