% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ssaStochKit2RInterface}
\alias{ssaStochKit2RInterface}
\title{C++ Interface to Gillespie Stochastic Simulation Algorithm}
\usage{
ssaStochKit2RInterface(StochKit2Rmodel, outputDirNameString, time, realizations,
  intervals, keepStats, keepTrajectories, keepHistograms, bins, seed, p)
}
\arguments{
\item{StochKit2Rmodel}{R list (Rcpp List built from buildStochKit2Rmodel output)}

\item{outputDirNameString}{Character string with path to output directory. Should end in path separator.}

\item{time}{Simulation time of each realization}

\item{realizations}{Number of realizations}

\item{intervals}{Number of output intervals. Default 0 outputs at end time only. 1=keep data at start and end time, 2=keep data at start, middle, and end times, etc. Note data is stored at (intervals+1) equally spaced time points.}

\item{keepStats}{Keep means and variances data}

\item{keepTrajectories}{Keep trajectory data}

\item{keepHistograms}{Keep histogram data}

\item{bins}{Number of histogram bins}

\item{seed}{Seed for random number generator}

\item{p}{Override default and specify the number of processes (threads) to use. By default (=0), the number of processes will be determined automatically}
}
\description{
\code{ssa} Called by StochKit2R ssa function, do not call this C++ interface directly
}
\keyword{internal}

