% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getSSHS}
\alias{getSSHS}
\alias{getSSHS,storm-method}
\alias{getSSHS,stormsList-method}
\title{Getting maximum Saffir-Simpson hurricane wind scale category}
\usage{
getSSHS(s)

\S4method{getSSHS}{storm}(s)

\S4method{getSSHS}{stormsList}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}
}
\value{
numeric vector.
}
\description{
The \code{getSSHS()} function return the maximum Saffir-Simpson hurricane
wind scale category reached by each storm in the \code{storm} or \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting maximum Saffir-Simpson hurricane wind scale category
#reached by each storm in the sts object
getSSHS(sts)
}
}
