% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cps}
\alias{cps}
\title{Conditional Poisson sampling design}
\usage{
cps(pik, eps = 1e-06)
}
\arguments{
\item{pik}{A vector of inclusion probabilities.}

\item{eps}{A scalar that specify the tolerance to transform a small value to the value 0.}
}
\value{
A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
}
\description{
Maximum entropy sampling with fixed sample size. It select a sample with fixed sample size with unequal inclusion probabilities.
}
\details{
Conditional Poisson sampling, the sampling design maximizes the entropy:
\deqn{I(p) = - \sum s p(s) log[p(s)].}
where s is of fixed sample size. Indeed, Poisson sampling is known for maximizing the entropy but has no fixed sample size. The function selects a sample of fixed sample that maximizes entropy.

This function is a C++ implementation of \code{\link[sampling:UPmaxentropy]{UPmaxentropy}} of the package \code{sampling}. More details could be find in Tille (2006).
}
\examples{

pik <- inclprob(seq(100,1,length.out = 100),10)
s <-  cps(pik)



# simulation with piktfrompik MUCH MORE FASTER
s <- rep(0,length(pik))
SIM <- 100
pikt <- piktfrompik(pik)
w <- pikt/(1-pikt)
q <- qfromw(w,sum(pik))
for(i in 1 :SIM){
  s <- s + sfromq(q)
}
p <- s/SIM # estimated inclusion probabilities
t <- (p-pik)/sqrt(pik*(1-pik)/SIM)
1 - sum(t > 1.6449)/length(pik) # should be approximately equal to 0.95 

}
\references{
Tille, Y. (2006), Sampling Algorithms, springer
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
