% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{inclprob}
\alias{inclprob}
\title{Inclusion Probabilities}
\usage{
inclprob(x, n)
}
\arguments{
\item{x}{vector of positive numbers.}

\item{n}{sample size (could be a positive real value).}
}
\value{
A vector of inclusion probabilities proportional to \code{x} and such that the sum is equal to the value \code{n}.
}
\description{
Computes first-order inclusion probabilities from a vector of positive numbers.
}
\details{
The function is implemented in C++ so that it can be used in the code of other C++ functions. The implementation is based on the function  \code{\link[sampling]{inclusionprobabilities}} of the package sampling.
}
\examples{

x <- runif(100)
pik <- inclprob(x,70)
sum(pik)

}
\seealso{
\code{\link[sampling]{inclusionprobabilities}}
}
\author{
Raphael Jauslin \email{raphael.jauslin@unine.ch}
}
