% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dipfix.R
\name{dipfix}
\alias{dipfix}
\title{Fix Dip}
\usage{
dipfix(strike, dip, quadrant = NA, inverted = NA)
}
\arguments{
\item{strike}{strike of the data; it is the angle from the north of
the horizontal line of the plane. Corrected, its range goes from 0° to 360°.}

\item{dip}{dip of the data; it is the angle from the horizontal taken
on the line of the plane perpendicular to the one of the strike. In other
words it is the plane's maximum angular deviation from the horizontal.
It is positive downward, and ranges from +90° for straight down to -90° for
straight up. Dip values in [-180,-90] or/and ]90,180] indicate inversion of
the plane.}

\item{quadrant}{the quadrant where the plane dips downward. Accepted
values are NA, 'N', 'S', 'W' or 'E' (lower- or uppercase alike). Is
independant of inversion}

\item{inverted}{whether the plane is upside down.}
}
\value{
a list of the corrected strike, dip and quadrant
}
\description{
Fix dip and strike of planes so that they fall in the correct
quadrant. The provided quadrant is the determining factor. If unavailable or
not helpful, the sign of the dip is used as dtermining factor.
}
\details{
the strike will be corrected as the orientation of the dip (i.e.
downward) minus 90°; it ranges from 0 to 360°. It is determined firstly from
the quadrant. If the quadrant is missing or not helpful (e.g. 'N' or 'S' for
a strike of 0° or 180°, 'E' or 'W' for a strike of 90° or 270°), it is
determined using the sign of the dip. Inversion will be indicated if the dip
values are in [-180,-90] or/and ]90,180], or simply if inverted = T. The
inversion does not influence the calculation of the strike, dip and quadrant:
whether the plane is upside down does not change these parameters output.
}
\examples{
strike   <- c(-60, 180,20,0,20)
dip      <- c(-60,20,-45,110,-90)
quadrant <- c("N",NA,NA,NA,"E")
inverted <- c(FALSE,TRUE,FALSE,TRUE,FALSE)

dipfix(strike,dip,quadrant,inverted)

dipfix(strike,dip,quadrant)

}
\seealso{
\code{\link{fmod}}, \code{\link{incfix}} and \code{\link{transphere}}
}
