% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDrugStructure.R
\name{plotDrugStructure}
\alias{plotDrugStructure}
\title{Visualize the chemical structure of the drug}
\usage{
plotDrugStructure(
  drug.label = "",
  main = "",
  sub = "",
  cex.main = 1.5,
  cex.sub = 1
)
}
\arguments{
\item{drug.label}{A character string of drug label to determine which drug to use for visualization.}

\item{main}{An overall title for the chemical structure graph.}

\item{sub}{A sub title for the chemical structure graph.}

\item{cex.main}{The magnification to be used for main titles (default: 1.5).}

\item{cex.sub}{The magnification to be used for sub titles relative to the
current setting of cex.}
}
\value{
A plot.
}
\description{
`plotDrugStructure()` outputs the chemical structure graph of the
drug or compound based on the input drug label by the user.
}
\details{
plotDrugStructure
}
\examples{
\donttest{require(rvest)}
\donttest{require(ChemmineR)}
# Plot the chemical structure of drug beclometasone.
\donttest{plotDrugStructure(drug.label="pirenperone(1.02e-05M)")}
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
