% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_cluster.R
\name{supercell_cluster}
\alias{supercell_cluster}
\title{Cluster super-cell data}
\usage{
supercell_cluster(
  D,
  k = 5,
  supercell_size = NULL,
  algorithm = c("hclust", "PAM"),
  method = NULL,
  return.hcl = TRUE
)
}
\arguments{
\item{D}{a dissimilarity matrix or a dist object}

\item{k}{number of clusters}

\item{supercell_size}{a vector with supercell size (ordered the same way as in D)}

\item{algorithm}{which algorithm to use to compute clustering: \code{"hclust"} (default) or \code{"PAM"} (see \link[WeightedCluster]{wcKMedoids})}

\item{method}{which method of algorithm to use: \itemize{
  \item for \code{"hclust"}: "ward.D", "ward.D2" (default), "single", "complete", "average", "mcquitty", "median" or "centroid", (see \link[stats]{hclust})
  \item for \code{"PAM"}: "KMedoids", "PAM" or "PAMonce" (default), (see \link[WeightedCluster]{wcKMedoids})
}}

\item{return.hcl}{whether to return a result of \code{"hclust"} (only for \code{"hclust"} algorithm)}
}
\value{
a list with components
\itemize{
  \item clustering - vector of clustering assignment of super-cells
  \item algo - the algorithm used
  \item method - method used with an algorithm
  \item hlc - \link[stats]{hclust} result (only for \code{"hclust"} algorithm when \code{return.hcl} is TRUE)
}
}
\description{
Cluster super-cell data
}
