% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_SurvSurv_copula.R
\name{estimate_mutual_information_SurvSurv}
\alias{estimate_mutual_information_SurvSurv}
\title{Estimate the Mutual Information in the Survival-Survival Setting}
\usage{
estimate_mutual_information_SurvSurv(delta_S, delta_T, minfo_prec)
}
\arguments{
\item{delta_S}{(numeric) Vector of individual causal treatment effects on the
surrogate.}

\item{delta_T}{(numeric) Vector of individual causal treatment effects on the
true endpoint.}

\item{minfo_prec}{Number of quasi Monte-Carlo samples for the numerical
integration to obtain the mutual information. If this value is 0 (default),
the mutual information is not computed and \code{NA} is returned for the mutual
information and derived quantities.}
}
\value{
(numeric) estimated mutual information.
}
\description{
\code{\link[=estimate_mutual_information_SurvSurv]{estimate_mutual_information_SurvSurv()}} estimates the mutual information for
a sample of individual causal treatment effects with a time-to-event
surrogate and a time-to-event true endpoint. The mutual information is
estimated by first estimating the bivariate density and then computing the
mutual information for the estimated density.
}
