% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITCI-Dvine-inference-utils.R
\name{summary_level_bootstrap_ICA}
\alias{summary_level_bootstrap_ICA}
\title{Bootstrap based on the multivariate normal sampling distribution}
\usage{
summary_level_bootstrap_ICA(
  fitted_model,
  copula_par_unid,
  copula_family2,
  rotation_par_unid,
  n_prec,
  B,
  measure = "ICA",
  mutinfo_estimator = NULL,
  composite,
  seed,
  restr_time = +Inf,
  ncores = 1
)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
contains the estimated identifiable part of the joint distribution for the
potential outcomes.}

\item{copula_par_unid}{Parameter vector for the sequence of \emph{unidentifiable}
bivariate copulas that define the D-vine copula. The elements of
\code{copula_par} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par_unid}{Vector of rotation parameters for the sequence of
\emph{unidentifiable} bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{23}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{n_prec}{Number of Monte Carlo samples for the computation of the mutual
information.}

\item{B}{Number of bootstrap replications}

\item{measure}{Compute intervals for which measure of surrogacy? Defaults to
\code{"ICA"}. See first column names of \code{sens_results} for other possibilities.}

\item{mutinfo_estimator}{Function that estimates the mutual information
between the first two arguments which are numeric vectors. Defaults to
\code{FNN::mutinfo()} with default arguments.
@param plot_deltas (logical) Plot the sampled individual treatment effects?}

\item{composite}{(boolean)  If \code{composite} is \code{TRUE}, then the surrogate
endpoint is a composite of both a "pure" surrogate endpoint and the true
endpoint, e.g., progression-free survival is the minimum of time-to-progression
and time-to-death.}

\item{seed}{Seed for Monte Carlo sampling. This seed does not affect the global
environment.}

\item{restr_time}{Restriction time for the potential outcomes. Defaults to
\code{+Inf} which means no restriction. Otherwise, the sampled potential outcomes
are replace by \code{pmin(S0, restr_time)} (and similarly for the other potential
outcomes).}

\item{ncores}{Number of cores used in the sensitivity analysis. The
computations are computationally heavy, and this option can speed things up
considerably.}
}
\value{
(numeric) Vector of bootstrap replications for the estimated ICA.
}
\description{
\code{\link[=summary_level_bootstrap_ICA]{summary_level_bootstrap_ICA()}} performs a parametric type of bootstrap based
on the estimated multivariate normal sampling distribution of the maximum
likelihood estimator for the (observable) D-vine copula model parameters.
}
\details{
Let \eqn{\hat{\boldsymbol{\beta}}} be the estimated identifiable parameter
vector, \eqn{\hat{\Sigma}} the corresponding estimated covariance matrix, and
\eqn{\boldsymbol{\nu}} a fixed value for the sensitivity parameter. The
bootstrap is then performed in the following steps
\enumerate{
\item Resample the identifiable parameters from the estimated sampling distribution,
\deqn{\hat{\boldsymbol{\beta}}^{(b)} \sim N(\hat{\boldsymbol{\beta}}, \hat{\Sigma}).}
\item For each resampled parameter vector and the fixed sensitivty parameter,
compute the ICA as \eqn{ICA(\hat{\boldsymbol{\beta}}^{(b)},
\boldsymbol{\nu})}.
}
}
