% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_BinCont_copula.R
\name{estimate_ICA_BinCont}
\alias{estimate_ICA_BinCont}
\title{Estimate ICA in Binary-Continuous Setting}
\usage{
estimate_ICA_BinCont(delta_S, delta_T)
}
\arguments{
\item{delta_S}{(numeric) Vector of individual causal treatment effects on the
surrogate.}

\item{delta_T}{(integer) Vector of individual causal treatment effects on the true
endpoint. Should take on one of the following values: \code{-1L}, \code{0L}, or \code{1L}.}
}
\value{
(numeric) Estimated ICA
}
\description{
\code{estimate_ICA_BinCont()} estimates the individual causal association (ICA)
for a sample of individual causal treatment effects with a continuous
surrogate and a binary true endpoint. The ICA in this setting is defined as
follows, \deqn{R^2_H = \frac{I(\Delta S; \Delta T)}{H(\Delta T)}} where
\eqn{I(\Delta S; \Delta T)} is the mutual information and \eqn{H(\Delta T)}
the entropy.
}
