% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/risk_newdat.R
\name{risk_newdat}
\alias{risk_newdat}
\title{Main function of SurvRank.}
\usage{
risk_newdat(dat_new, sel_names, dat_old, cv.out = 10, c.time = NA,
  detail = NA, plot = F, surv.tab = c(0.5), mcox = T)
}
\arguments{
\item{dat_new}{a new data set that is not used for the model building but only for prediction}

\item{sel_names}{the variables that were selected (from riskscore_fct) (see \code{\link{CVrankSurv_fct}})}

\item{dat_old}{the data set used to fit the survival model}

\item{cv.out}{number of cross-validation folds for the prediction}

\item{c.time}{as defined in UnoC{survAUC} time; a positive number restricting the upper limit of the time range under consideration}

\item{detail}{TRUE do the prediction and Uno's C-Statistic computation for the models using 1:\code{sel_names} variables FALSE only save the statistics for the different cross validation folds}

\item{plot}{TRUE do a plot of the survival curves FALSE no plot}

\item{surv.tab}{Defaults to c(0.5). Calculates for selected features survival curves. \code{surv.tab} determines quantiles of predictions.}

\item{mcox}{TRUE a cox model is fitted FALSE a Cox model with ridge penalty using \code{cv.out} cross-validation folds is fitted}
}
\value{
Output of the \code{risk_newdat}, basically a list containing the following elements
\item{\code{unocv}}{Matrix of censoring-adjusted C-statistic by Uno et al. for the different cross-validation folds and if \code{detail=T} as well for different number of variables }
\item{\code{unoi}}{if \code{detail=T} Vector of censoring-adjusted C-statistic by Uno et al. for the different number of variables, if \code{detail=FALSE} it correspons to \code{uno_new} }
\item{\code{rs}}{model prediction for the new data set}
\item{\code{sfit.tab}}{survfit object according to \code{surv.tab} seperation}
\item{\code{sfit.diff}}{surfdiff: Tests if there is a difference between two or more survival curves using the G-rho family of tests, or for a single curve against a known alternative}
\item{\code{model}}{model output for \code{dat_old} and using the variables given by \code{sel_names}}
\item{\code{uno_new}}{the censoring-adjusted C-statistic by Uno et al. using the prediction for \code{dat_new}}
Additionally if \code{plot} is \code{T}, the survival curves given by \code{sfit.tab} are plotted
}
\description{
Main input function for SurvRank.
}
\details{
details to follow
}
\examples{
## Simulating a survival data set
N=100; p=10; n=3
x=data.frame(matrix(rnorm(N*p),nrow=N,p))
beta=rnorm(n)
mx=matrix(rnorm(N*n),N,n)
fx=mx[,seq(n)]\%*\%beta/3
hx=exp(fx)
ty=rexp(N,hx)
tcens=1-rbinom(n=N,prob=.3,size=1)
y=Surv(ty,tcens)
data=list()
data$x<-x; data$y<-y
## CV object
out<-CVrankSurv_fct(data,2,3,3,fs.method="cox.rank")
## The variables selected from the \\code{\\link{riskscore_fct}}
selected<-riskscore_fct(out,data,list.t="weighted")$selnames
## Applying the risk_newdat function
x=data.frame(matrix(rnorm(N*p),nrow=N,p))
beta=rnorm(n)
mx=matrix(rnorm(N*n),N,n)
fx=mx[,seq(n)]\%*\%beta/3
hx=exp(fx)
ty=rexp(N,hx)
tcens=1-rbinom(n=N,prob=.3,size=1)
y=Surv(ty,tcens)
data_new=list()
data_new$x<-x; data_new$y<-y
risk<-risk_newdat(data_new,selected,data)
}
\keyword{SurvRank}

