% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residDiagnostics.R
\name{plot_residDiagnostics}
\alias{plot_residDiagnostics}
\title{Plots for residuals diagnostics}
\usage{
plot_residDiagnostics(model)
}
\arguments{
\item{model}{An object of class "lme" representing the linear mixed-effects model fitted by \code{\link[=lmmModel]{lmmModel()}}.}
}
\value{
A list with different plots for evaluating the normality and homoscedasticity of the normalized residuals
(standardized residuals pre-multiplied by the inverse square-root factor of the estimated error correlation matrix, see \link[nlme:residuals.lme]{nlme::residuals.lme}), including:
\itemize{
\item A normal Q-Q plot of the normalized residuals of the model.
\item A normal Q-Q plot of the normalized residuals of the model by Time.
\item A normal Q-Q plot of the normalized residuals of the model by Treatment.
\item A dotplot of normalized residuals vs fitted values.
\item A dotplot of the normalized residuals by Time and Treatment.
}
}
\description{
Visualization of residuals diagnostics for a fitted linear mixed model of tumor growth data.
}
\examples{
data(grwth_data)
# Fit the model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination",
  show_plot = FALSE
  )
# Generate plots 
plot_residDiagnostics(lmm)
# Access to specific plots
plot_residDiagnostics(lmm)[[1]]
plot_residDiagnostics(lmm)[[2]]
}
