% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizeTailoredExercisePlan.R
\name{VisualizeTailoredExercisePlan}
\alias{VisualizeTailoredExercisePlan}
\title{Visualize Tailored Exercise Plan for T2D Patients}
\usage{
VisualizeTailoredExercisePlan(
  demo_result,
  sample_selection = "all",
  sort_by = "head",
  exercise_type = "all",
  nrow = "auto",
  ncol = "auto",
  show_legend = TRUE
)
}
\arguments{
\item{demo_result}{A list containing two data frames (\verb{$RecommendedExercisePlan} and \verb{$AllExercisePlan}) as returned by the \code{TailorExercisePlan} function.}

\item{sample_selection}{Specifies which patient samples to visualize, accepting three types of inputs:
\itemize{
\item{"all": Visualizes all samples.}
\item{Given names (character vector): Names of specific patients for visualization.}
\item{Numeric value: A numeric index indicating the number of samples to visualize.}
}}

\item{sort_by}{Determines the sorting orientation for the visualization, affecting which samples are prioritized:
\itemize{
\item{"head": Prioritizes samples towards the beginning of the selection.}
\item{"tail": Prioritizes samples towards the end of the selection.}
}}

\item{exercise_type}{Specifies the type(s) of exercises to include in the visualization. Accepts multiple input types:
\itemize{
\item{"all": Includes all types of exercises.}
\item{"best": Selects the exercise(s) with the highest predicted reduction in HbA1c.}
\item{Given types (character vector): Specific exercises, including "Taiji", "Qigong", "Stretching", "Rugby", "Cycling", and "Walking".}
}}

\item{nrow}{The number of rows in the visualization grid, which can be:
\itemize{
\item{"auto": Automatically calculates the number of rows based on the number of samples and other parameters.}
\item{Numeric value: Specifies the exact number of rows for the layout.}
}}

\item{ncol}{The number of columns in the visualization grid, which can be:
\itemize{
\item{"auto": Automatically calculates the number of columns based on the number of samples, the specified number of rows, and other parameters.}
\item{Numeric value: Specifies the exact number of columns for the layout.}
}}

\item{show_legend}{A logical value indicating whether to display a legend in the plots. TRUE or FALSE.}
}
\value{
The function does not return a data structure, but rather invisibly produces radar charts.
These charts visualize the expected HbA1c decrease value and other relevant details for each recommended exercise plan for T2D patients.
}
\description{
This function visualizes the exercise plan recommendations for Type 2 Diabetes (T2D) patients by generating radar charts.
}
\examples{
# Create a demo dataframe
#' set.seed(16)
df <- data.frame(
Age = sample(39:77, 8, replace = TRUE),
Sex = sample(0:1, 8, replace = TRUE),
BMI = sample(18:31, 8, replace = TRUE),
Duration_T2D = sample(1:26, 8, replace = TRUE),
HDL = sample(1:1.7, 8, replace = TRUE),
PCS = sample(27:54, 8, replace = TRUE),
WHtR = sample(0.4:0.6, 8, replace = TRUE)
)
rownames(df) <- c("xiaoming", "xiaohong", "xiaohua", "xiaogang",
                  "xiaoli", "zhangsan", "lisi", "wangwu")
colnames(df) <- c("Age", "Sex", "BMI", "Duration_T2D (year)",
                  "HDL (mmol/L)", "PCS", "WHtR")
# Run the TailorExercisePlan function
demo_result <- TailorExercisePlan(df)

# visualize the outcome from 'TailorExercisePlan' function
VisualizeTailoredExercisePlan(demo_result, sample_selection="all",
                              sort_by="head", exercise_type="all",
                              nrow="auto", ncol="auto", show_legend=TRUE)

VisualizeTailoredExercisePlan(demo_result, sample_selection="zhangsan",
                              sort_by="head", exercise_type="all",
                              nrow="auto", ncol="auto", show_legend=TRUE)

VisualizeTailoredExercisePlan(demo_result, sample_selection=c("zhangsan","lisi"),
                              sort_by="head", exercise_type="all",
                              nrow="auto", ncol="auto", show_legend=TRUE)

VisualizeTailoredExercisePlan(demo_result, sample_selection=1,
                              sort_by="head", exercise_type="all",
                              nrow="auto", ncol="auto", show_legend=TRUE)

VisualizeTailoredExercisePlan(demo_result, sample_selection="all",
                              sort_by="head", exercise_type="best",
                              nrow="auto", ncol="auto", show_legend=TRUE)

}
