% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_code.R
\name{render_code}
\alias{render_code}
\title{Generate a file with formatted code}
\usage{
render_code(
  output = "word",
  browser = getOption("browser"),
  font_size = 12,
  code = TRUE,
  ...
)
}
\arguments{
\item{output}{a string. The output format ("pdf", "html" or "word" are
accepted)}

\item{browser}{a string. The path to the browser which will open the
generated file format}

\item{font_size}{a numeric. The font size in pdf format.}

\item{code}{a boolean. Does the copied content is}

\item{...}{other arguments passed to R chunk (for example eval = TRUE,
echo = FALSE...)}
}
\value{
This function returns invisibly (with \code{invisible()})
\code{NULL}.
}
\description{
Format a piece of code to copy it into an email, a pdf, a document, etc.
}
\details{
This function allows the user to generate formatted code (for email,
document, copy, message, etc.) on the fly.

It accepts mainly word, pdf and html formats, but any format accepted by
rmarkdown on the computer.

To use this function, simply copy a piece of code and run
\code{render_code()} with the arguments that interest us.
If you want content that is not R code, use the \code{code} argument to
\code{FALSE}.
In pdf format, you can change the font size using the \code{font_size}
argument.
Also, you can change the browser that opens the file by default with the
\code{browser} argument.
With the argument \dots, you can specify knitr arguments to be included in
the chunk. For example, you can add \code{eval = TRUE} (if you want the R
code to be evaluated (and the result displayed)), \code{echo = FALSE} (if
you don't want to display the code)... More information in the function
\code{\link[knitr]{opts_chunk}} or directly
\url{https://yihui.org/knitr/options/#chunk-options} to see all available
options and their descriptions.
}
\examples{
# Copy a snippet of code
if (clipr::clipr_available()) {
    clipr::write_clip("plot(AirPassengers)", allow_non_interactive = TRUE)
}

render_code(
    output = "word",
    echo = TRUE
)

render_code(
    output = "html",
    eval = FALSE
)

\donttest{
render_code(
    output = "pdf",
    eval = TRUE,
    font_size = 16
)
}
}
