% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learnDbnStruct3dParDeg1.R
\name{learnDbnStructLayer3dParDeg1}
\alias{learnDbnStructLayer3dParDeg1}
\title{Unrolled DBN structure learning with Markov Order 0 and 1.}
\usage{
learnDbnStructLayer3dParDeg1(input.data.discr.3D, mi.net.adj.matrix,
  num.discr.levels, num.nodes, num.timepts, output.dirname = "./OUTPUT")
}
\arguments{
\item{input.data.discr.3D}{Dimensions {1 = time points, 2 = variables, 3 = samples under the same time point}.}

\item{mi.net.adj.matrix}{Adjacency matrix of the mutual information network. Rownames and colnames should be node names.}

\item{num.discr.levels}{If input data is discretized, then number of discrete levels for each variable. Else if input data is continuous, then number of levels in which data needs to be discretized for performing the DBN structure learning.}

\item{num.nodes}{number of nodes}

\item{num.timepts}{number of timepoints}

\item{output.dirname}{output directory to store files}
}
\value{
Unrolled DBN adjacency matrix
}
\description{
Unrolled DBN structure learning with Markov Order 0 and 1.
Candidate parents: The target node itself and its CLR net neighbours at immediately previous and current time pt.
}
