% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLum.Analysis-class.R
\docType{class}
\name{TLum.Analysis-class}
\alias{TLum.Analysis-class}
\alias{get_TLum.Analysis}
\alias{get_TLum.Analysis,TLum.Analysis-method}
\alias{set_TLum.Analysis}
\alias{set_TLum.Analysis,TLum.Analysis-method}
\alias{set_TLum.Analysis,list,ANY,character,list-method}
\alias{show,TLum.Analysis-method}
\title{Class \code{"TLum.Analysis"}}
\usage{
\S4method{show}{TLum.Analysis}(object)

set_TLum.Analysis(records, protocol, history, plotHistory)

\S4method{set_TLum.Analysis}{list,ANY,character,list}(records, protocol,
  history, plotHistory)

get_TLum.Analysis(object, record.id, recordType, curveType, TLum.type,
  get.index, keep.object = FALSE)

\S4method{get_TLum.Analysis}{TLum.Analysis}(object, record.id, recordType,
  curveType, TLum.type, get.index, keep.object = FALSE)
}
\arguments{
\item{object}{\linkS4class{TLum.Analysis}: an object of class TLum.Analysis.}

\item{records}{\link{list}: list of \linkS4class{TLum.Data.Curve} objects}

\item{protocol}{\link{character}: protocol type for analysis object.}

\item{history}{\link{character}: Vector containing the previous modification made on the data set.}

\item{plotHistory}{\link{list}: Data for plotting the evolution of the data set.}

\item{record.id}{\link{numeric}: IDs of specific records.}

\item{recordType}{\link{character}: record type.}

\item{curveType}{\link{character}: curve type.}

\item{TLum.type}{\link{character}: TLum object type.}

\item{get.index}{\link{logical}: return a numeric vector with the index of each element in the TLum.Analysis object.}

\item{keep.object}{\link{logical}: return a TLum.Analysis object.}
}
\description{
Object class containing analysis data for protocol analysis.
}
\section{Slots}{

\describe{
\item{\code{protocol}}{\link{character}: Protocol used for the analysis.}

\item{\code{records}}{\link{list}: \linkS4class{TLum.Data.Curve} included in the analysis.}

\item{\code{history}}{\link{character}: Vector containing the previous modification made on the data set.}

\item{\code{plotHistory}}{\link{list}: Data for plotting the evolution of the data set.}
}}
\note{
The code and the structure of this class is based on the \linkS4class{RLum.Analysis} class from the \link{Luminescence} package.
}
\author{
David Strebler
}
\keyword{classes}

