% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trop_ball.R
\name{Trop_ball}
\alias{Trop_ball}
\title{Visualize a Tropical ball in 2D or 3D}
\usage{
Trop_ball(
  v,
  d,
  a = 1,
  cls = "black",
  cent.col = "black",
  fil = TRUE,
  plt = TRUE,
  bord = "black"
)
}
\arguments{
\item{v}{center of tropical ball; numeric vector of length 3 or 4}

\item{d}{radius of tropical ball}

\item{a}{shading level; 1 is opaque}

\item{cls}{string indicating color of interior of ball}

\item{cent.col}{string indicating color of center point}

\item{fil}{logical for 3D plots; if TRUE 2D facets of 3D ball fill in color of cls parameter}

\item{plt}{logical; indicates plot a new object; defaults to TRUE; if FALSE, overlays the ball on existing plot}

\item{bord}{string indicating color of border of ball (only for 2D plots)}
}
\value{
2D or 3D visualization of tropical ball
}
\description{
This function constructs a visualization of a 2D or 3D tropical ball
}
\examples{
v <-c(0,0,0)
d <- 2
Trop_ball(v,d,a=.1,cls='white',cent.col='black',fil=TRUE,plt=TRUE,bord='black')
v <-c(0,0,0,0)
d <- 2
Trop_ball(v,d,a=1,cls='red',cent.col='black',fil=FALSE,plt=TRUE)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
