% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.PCA.R
\name{tropical.PCA}
\alias{tropical.PCA}
\alias{tropical.PCA.Polytope}
\title{Tropical principal component analysis (PCA) on over tropical projective torus}
\usage{
tropical.PCA.Polytope(S, D, V, I = 1, k)
}
\arguments{
\item{S}{inital set of vertices for the tropical triangle}

\item{D}{matrix of data where each row is an observation in the tropical projective torus}

\item{V}{matrix of vertices defining a polytope encompassing D}

\item{I}{number of iterations to perform}

\item{k}{number of iterations for the HAR sampler}
}
\value{
list with the sum of residuals
}
\description{
This function conducts tropical PCA to find the best fit tropical triangle given data defined in the tropical projective torus.
It employs the vertex HAR with extrapolation sampler to sample points to determine the vertices of the tropical triangle.
}
\examples{
\donttest{
s <- 3 #number of vertices.  Here it is a tropical triangle
d <- 3 ## dimension
N <- 100 ## sample size
V <- matrix(c(100, 0, 0, 0, 100, 0, 0, 0, 100, -100, 0, 0, 0, -100, 0, 0, 0, -100), 6, 3, TRUE)
D <- matrix(rep(0, N*d), N, d)
D[, 1] <- rnorm(N, mean = 5, sd = 5)
D[, 2] <- rnorm(N, mean = -5, sd = 5)
D[, 3] <- rnorm(N, mean = 0, sd = 5)
index <- sample(1:N, s)
S <- D[index,]
DD <- pre.pplot.pro(S, D)
for(i in 1:N)
 DD[i, ] <- normaliz.vector(DD[i, ])

res <- tropical.PCA.Polytope(S, D, V, I = 1000,50)
DD <- pre.pplot.pro(res[[2]], res[[3]])
trop.tri.plot.w.pts(normaliz.ultrametrics(res[[2]]), DD)
}
}
\references{
Page, Robert and others (2020), Tropical principal component analysis on the space of phylogenetic trees, Bioinformatics, Volume 36, Issue 17, Pages 4590–4598.

Yoshida, R., Zhang, L. & Zhang, X (2019). Tropical Principal Component Analysis and Its Application to Phylogenetics. Bull Math Biol 81, 568–597.
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
