% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.tpolytope.R
\name{draw.tpolytope}
\alias{draw.tpolytope}
\alias{draw.tpolytope.3d}
\alias{draw.tpolytope.2d}
\title{Draw a 2-D or 3-D tropical polytope}
\usage{
draw.tpolytope.3d(D, c, cc, plt = TRUE)

draw.tpolytope.2d(D, c, cc, plt = TRUE)
}
\arguments{
\item{D}{matrix of vertices of a tropical polytope; rows are the vertices}

\item{c}{string; color to render the polytope.}

\item{cc}{string; color to render the vertices.}

\item{plt}{logical; initiate new plot visualization or not.}
}
\value{
2-D or 3-D rendering of a tropical polytope.
}
\description{
This command draws a three dimensional tropical polytope
}
\examples{
D <-matrix(c(0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),4,4,TRUE)
c<-'blue'
cc<-'red'
draw.tpolytope.3d(D,c,cc,plt=TRUE)

D <- matrix(c(0,-2,2,0,-2,5,0,2,1,0,1,-1),4,3,TRUE)
c <- 'blue'
cc <- 'red'
draw.tpolytope.2d(D,c,cc,plt=TRUE)


}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
