% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kFWER_TMTI.R
\name{kFWER_TMTI}
\alias{kFWER_TMTI}
\title{kFWER_TMTI. Computes the largest rejection set possible with kFWER control.}
\usage{
kFWER_TMTI(
  pvals,
  k,
  alpha = 0.05,
  B = 1000,
  gammaList = NULL,
  tau = NULL,
  K = NULL,
  verbose = FALSE
)
}
\arguments{
\item{pvals}{A vector p-values.}

\item{k}{An integer denoting the desired k at which to control the kFWER.}

\item{alpha}{Significance level.}

\item{B}{Number of bootstrap replications if gamma needs to be approximated.
Not used if specifying a list of functions using the gammaList argument
or if length(pvals) <= 100. Defaults to 1000.}

\item{gammaList}{A list of pre-specified gamma functions. If NULL, gamma
functions will be approximated via bootstrap, assuming independence. Defaults
to NULL.}

\item{tau}{Numerical (in (0,1)); threshold to use in tTMTI. If set to NULL,
then either TMTI (default) or rtTMTI is used.}

\item{K}{Integer; Number of smallest p-values to use in rtTMTI. If se to NULL,
then either TMTI (default) or tTMTI is used.}

\item{verbose}{Logical, indicating whether or not to print progress.}
}
\value{
The number of marginal hypotheses that can be rejected with kFWER control.
}
\description{
kFWER_TMTI. Computes the largest rejection set possible with kFWER control.
}
\examples{
nfalse = 50
m = 100
pvals = c (
  sort(runif(nfalse, 0, 0.05 / m)),
  sort(runif(m - nfalse, 0.1, 1))
)
kFWER_TMTI (
  pvals = pvals,
  k = 5,
  alpha = 0.05,
  verbose = FALSE
)
}
