% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equ_anova.R
\name{equ_anova}
\alias{equ_anova}
\title{Equivalence Test for ANOVA Results}
\usage{
equ_anova(object, eqbound, MET = FALSE, alpha = 0.05)
}
\arguments{
\item{object}{an object of returned by either \code{Anova},
\code{aov}, or \code{afex_aov}}

\item{eqbound}{Equivalence bound for the partial eta-squared.}

\item{MET}{logical indicator to perform a minimal effect test rather than equivalence test (default is FALSE).}

\item{alpha}{alpha used for the test (e.g., 0.05).}
}
\value{
Returns a data frame containing the ANOVA results with equivalence tests added.

The following abbreviations are used in the table:
\itemize{
\item effect: name of the effect.
\item df1:	Degrees of Freedom in the numerator (i.e. DF effect).
\item df2:	Degrees of Freedom in the denominator (i.e., DF error).
\item F:	F-value.
\item p.null:	p-value (probability of the data given the null hypothesis).
\item pes:	partial
Eta-Squared measure of effect size.
\item eqbound: equivalence bound.
\item p.equ: p-value (probability of the data given the equivalence hypothesis)
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs equivalence test on the partial eta-squared (pes) value from ANOVA results.
}
\details{
For details on the calculations in this function see \code{vignette("the_ftestTOSTER")}.
}
\section{References}{

Campbell, H., & Lakens, D. (2021). Can we disregard the whole model? Omnibus non‐inferiority testing for R2 in multi‐variable linear regression and in ANOVA. British Journal of Mathematical and Statistical Psychology, 74(1), 64-89. doi: 10.1111/bmsp.12201
}

\seealso{
Other f-test: 
\code{\link{equ_ftest}()}
}
\concept{f-test}
