% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsne_analysis.R
\name{tsne_analysis}
\alias{tsne_analysis}
\title{TSNE analysis for analyzing and visualizing TSNE algorithm.}
\usage{
tsne_analysis(sample_gene, group_sample, seed = 1, tsne_dims = 2)
}
\arguments{
\item{sample_gene}{Dataframe: All genes in all samples expression dataframe of RNA-Seq (1st-col: Genes, 2nd-col~: Samples).}

\item{group_sample}{Dataframe: Samples and groups for gene expression (1st-col: Samples, 2nd-col: Groups).}

\item{seed}{Numeric: set seed for robust result. Default: 1.}

\item{tsne_dims}{Numeric: TSNE dimensionality number. Default: 2.}
}
\value{
Table: TSNE analysis for analyzing and visualizing TSNE algorithm.
}
\description{
TSNE analysis for analyzing and visualizing TSNE algorithm.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression)
head(gene_expression)

data(samples_groups)
head(samples_groups)

# 3. Default parameters
res <- tsne_analysis(gene_expression, samples_groups)
head(res)

# 4. Set tsne_dims = 3
res <- tsne_analysis(gene_expression, samples_groups, tsne_dims = 3)
head(res)

}
\author{
benben-miao
}
