% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPC_pl_BIC.R
\name{TPC_pl_BIC}
\alias{TPC_pl_BIC}
\title{Variable Selection via Thresholded Partial Correlation}
\usage{
TPC_pl_BIC(y, x, u = NULL, s = 0.05, constant = 1, method = "threshold", ...)
}
\arguments{
\item{y}{response vector;}

\item{x}{covariate matrix;}

\item{u}{non-parametric variable, should be a vector;}

\item{s}{a value or a vector that used as significance level(s) for partial
correlation test. BIC will be used to select the best \code{s}.}

\item{constant}{a value or a vector that used as the tuning constant for partial
correlation test. BIC will be used to select the best \code{constant}.
\code{constant} is treated as 1 when method is "simple".}

\item{method}{the method to be used; default set as method = "threshold";
"simple" is also available.}

\item{...}{smoothing parameters and functions: \code{kernel}, \code{degree}, and bandwidth \code{h}.}
}
\value{
TPC.object a TPC object, which extends the \code{lm} object. New attributes are:
\itemize{
\item beta - the fitted coefficients
\item selected_index - the selected coefficients indices
}
}
\description{
Use BIC to select the best \code{s} and \code{constant} over grids.
}
\examples{

#generate partial linear data
samples <- generate_toy_pldata()
y <- samples[[1]]
x <- samples[[2]]
times <- samples[[3]]

#perform variable selection via partial correlation
TPC.fit = TPC_pl_BIC(y,x,times,0.05,c(1,1.5),method="threshold")
TPC.fit$beta


}
