% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLA.fit.R
\name{TSLA.fit}
\alias{TSLA.fit}
\title{Solve the TSLA optimization problem}
\usage{
TSLA.fit(
  y,
  X_1 = NULL,
  X_2,
  treemat,
  family = c("ls", "logit"),
  penalty = c("CL2", "RFS-Sum"),
  gamma.init = NULL,
  weight = NULL,
  group.weight = NULL,
  feature.weight = NULL,
  control = list(),
  modstr = list()
)
}
\arguments{
\item{y}{Response in matrix form, continuous for \code{family = "ls"} and binary (0/1)
for \code{family = "logit"}.}

\item{X_1}{Design matrix for unpenalized features (excluding intercept). Need to be in the matrix form.}

\item{X_2}{Expanded design matrix for \code{penalty = "CL2"}; Original design matrix
for \code{penalty = "RFS-Sum"}. Need to be in the matrix form.}

\item{treemat}{Expanded tree structure in matrix form for
\code{penalty = "CL2"}; Original structure for \code{penalty = "RFS-Sum"}.}

\item{family}{Two options. Use "ls" for least square problems and "logit"
for logistic regression problems.}

\item{penalty}{Two options for group penalty on \eqn{\gamma}, "CL2" or "RFS-Sum".}

\item{gamma.init}{Initial value for the optimization. Default is a zero vector.
The length should equal to 1+\code{ncol(X_1)}+\code{ncol(A)}.
See details of A in \code{get_tree_obj()}.}

\item{weight}{A vector of length two and it is used for logistic regression
only. The first element corresponds to weight of y=1 and the
second element corresponds to weight of y=0.}

\item{group.weight}{User-defined weights for group penalty. Need to be a vector
and the length equals to the number of groups.}

\item{feature.weight}{User-defined weights for each predictor after expansion.}

\item{control}{A list of parameters controlling algorithm convergence. Default values:
\code{tol = 1e-5}, convergence tolerance; \code{maxit = 10000},
maximum number of iterations; \code{mu = 1e-3}, smoothness parameter in SPG.}

\item{modstr}{A list of parameters controlling tuning parameters. Default values:
\code{lambda = NULL}. If lambda is not provided, the package will give a default lambda sequence;
\code{lambda.min.ratio = 1e-04}, smallest value for lambda as
a fraction of lambda.max (given by default when lambda is NULL);
\code{nlambda = 50},
number of lambda values (equal spacing on log scale) used when lambda is NULL;
\code{alpha = seq(0, 1, length.out = 10)}, sequence of alpha. Here, alpha is
tuning parameter for generalized lasso penalty and 1-alpha is the tuning
parameter for group lasso penalty.}
}
\value{
A list of model fitting results.
\item{gammacoef}{Estimation for \eqn{\gamma}.}
\item{groupnorm}{Weighted norms for each group.}
\item{lambda.seq}{Sequence of \eqn{\lambda} values.}
\item{alpha.seq}{Tuning parameter sequence for the generalized lasso penalty.}
\item{rmid}{Column index for all zero features.}
\item{family}{Option of \code{family}.}
\item{cov.name}{Names for unpenalized features.}
\item{bin.name}{Names for binary feautres.}
\item{tree.object}{Outputs from \code{get_tree_obj()}.}
}
\description{
Find the solutions with a Smoothing Proximal Gradient (SPG) algorithm
for a sequence of \eqn{\alpha} and \eqn{\lambda} values.
}
\details{
We adopt the warm start technique to speed up the calculation.
The warm start is applied with a fixed value of \eqn{\alpha} and a
descending sequence of \eqn{\lambda}.

The objective function for "ls" is
\deqn{1/2 RSS+\lambda(\alpha P(\beta)+(1-\alpha) P(\gamma)),}
subject to \eqn{\beta=A\gamma}.
The objective function for "logit" is
\deqn{-loglik + \lambda(\alpha P(\beta)+(1-\alpha) P(\gamma)),}
subject to \eqn{\beta=A\gamma}. Note that, in this package, the input parameter "alpha" is the
tuning parameter for the generalized lasso penalty.

Details for "penalty" option:

For \code{penalty = "CL2"}, see details for the
"Child-l2" penalty in the main paper.

For \code{penalty = "RFS-Sum"}, the theoretical optimal weights are used.
Please check the details in paper
"Rare feature selection in high dimensions".
}
\examples{
# Load the synthetic data
data(RegressionExample)

tree.org <- RegressionExample$tree.org   # original tree structure
x2.org <- RegressionExample$x.org      # original design matrix
y <- RegressionExample$y            # response

# Do the tree-guided expansion
expand.data <- getetmat(tree.org, x2.org)
x2 <- expand.data$x.expand              # expanded design matrix
tree.expand <- expand.data$tree.expand  # expanded tree structure

# specify some model parameters
set.seed(100)
control <- list(maxit = 100, mu = 1e-3, tol = 1e-5, verbose = FALSE)
# fit model with a pair of lambda and alpha
modstr <- list(lambda = 1,  alpha = 0.1)
x1 <- NULL
fit1 <- TSLA.fit(y, x1, x2, tree.expand, family = 'ls',
                 penalty = 'CL2',
                 gamma.init = NULL, weight = NULL,
                 group.weight = NULL, feature.weight = NULL,
                 control, modstr)
# get group norms from fit1
fit1$groupnorm
}
\references{
Chen, J., Aseltine, R. H., Wang, F., & Chen, K. (2024).
\emph{Tree-Guided Rare Feature Selection and Logic Aggregation with
Electronic Health Records Data. Journal of the American Statistical Association 119(547), 1765-1777},
\doi{10.1080/01621459.2024.2326621}.\cr
Chen, X., Q. Lin, S. Kim, J. G. Carbonell, and E. P. Xing (2012).
\emph{Smoothing proximal gradient method for general structured sparse regression.
The Annals of Applied Statistics 6(2), 719–752},
\doi{10.1214/11-AOAS514}.\cr
Yan, X. and J. Bien (2021).
\emph{Rare feature selection in high dimensions.
Journal of the American Statistical Association 116(534), 887–900},
\doi{10.1080/01621459.2020.1796677}.\cr
}
