% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/an.r
\name{an}
\alias{an}
\alias{an.rev}
\title{Adaptive Normalization}
\usage{
an(data, max = NULL, min = NULL, byRow = TRUE, outlier.rm = TRUE, alpha = 1.5)

an.rev(data, max, min, an)
}
\arguments{
\item{data}{A numeric matrix with sliding windows of time series data
as returned by \code{\link{sw}}.}

\item{max}{A numeric vector indicating the maximal values of each row 
(sliding window) in \code{data}. If \code{NULL} it is automatically computed.}

\item{min}{A numeric vector indicating the minimum values of each row 
(sliding window) in \code{data}. If \code{NULL} it is automatically computed.}

\item{byRow}{If \code{TRUE}, the normalization is performed by rows (sliding windows),
the default.}

\item{outlier.rm}{If \code{TRUE}, outlier values are removed from the data 
during the normalization process, the default.}

\item{alpha}{The multiplier for the interquartile range used as base for outlier removal. 
The default is set to \code{1.5}. The value \code{3.0} is also commonly used 
to remove only the extreme outliers.}

\item{an}{The mean of each data window computed by \code{an()} and returned as attribute.}
}
\value{
\code{data} normalized between 0 and 1.
	\code{max} and \code{min} are returned as attributes, as well as the mean values of each row 
		(sliding window) in \code{data} (\code{an}).
}
\description{
The \code{an()} function normalizes data of the provided time series 
to bring values into the range [0,1]. The function applies the method of 
Adaptive Normalization designed for non-stationary heteroscedastic 
(with non-uniform volatility) time series.
\code{an.rev()} reverses the normalization.
}
\examples{

data(CATS)
swin <- sw(CATS[,1],5)
d <- an(swin, outlier.rm=FALSE)
x <- an.rev(d, max=attributes(d)$max, min=attributes(d)$min, an=attributes(d)$an)
all(round(x,4)==round(swin,4))

}
\references{
E. Ogasawara, L. C. Martinez, D. De Oliveira, G. Zimbrao, G. L. Pappa, and M. Mattoso, 2010,
Adaptive Normalization: A novel data normalization approach for non-stationary time series, 
Proceedings of the International Joint Conference on Neural Networks.
}
\seealso{
Other normalization methods: 
\code{\link{minmax}()}
}
\author{
Rebecca Pontes Salles
}
\concept{normalization methods}
\keyword{normalization}
\keyword{series}
\keyword{time}
