% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIP.R
\name{repr_pip}
\alias{repr_pip}
\title{PIP representation}
\usage{
repr_pip(x, times = 10, return = "points")
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{times}{the number of important points to extract (default 10)}

\item{return}{what to return? Can be important points ("points"),
places of important points in a vector ("places") or "both" (data.frame).}
}
\value{
the values based on the argument return (see above)
}
\description{
The \code{repr_pip} computes PIP (Perceptually Important Points) representation from a time series.
}
\examples{
repr_pip(rnorm(100), times = 12, return = "both")

}
\references{
Fu TC, Chung FL, Luk R, and Ng CM (2008)
Representing financial time series based on data point importance.
Engineering Applications of Artificial Intelligence, 21(2):277-300
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
