% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TVsMiss.R
\name{plot.TVsMiss}
\alias{plot.TVsMiss}
\title{plot solution path from the fitted "TVsMiss" object}
\usage{
\method{plot}{TVsMiss}(x, label = FALSE, log = TRUE, ...)
}
\arguments{
\item{x}{fitted "TVsMiss" object}

\item{label}{If TRUE, the name of each predictor variable will be showed}

\item{log}{If TRUE, x-axis is log scale; if FALSE, x-axis is in normal scale}

\item{...}{graphical parameters to plot}
}
\description{
solution path is generated, the x-axis can be either in log or normal scale, the variable names
of each predictors can be chosen to show or not
}
\examples{
n <- 50
p <- 8
beta <- c(3,0,1.5,0,2,rep(0,p-5))
xm <- matrix(rnorm(n*p),ncol = p, nrow = n)
y <- xm \%*\% beta + rnorm(n)
colnames(xm) <- paste0("Var_",1:p)

fit01 <- tvsmiss(x=xm,y=y)
fit01$selection_beta
fit01$beta_matrix
plot(fit01)
plot(fit01,x.log=TRUE,label = FALSE)
plot(fit01,x.log=TRUE,label = TRUE)

fit04 <- tvsmiss(x=xm,y=y,penalty = "SCAD",method = "BIC")
fit04$selection_beta
fit04$beta_matrix
plot(fit04)
plot(fit04,x.log = TRUE)
plot(fit04,x.log = TRUE,label = TRUE)

}
