% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MasterEstim.R
\name{TemperedEstim}
\alias{TemperedEstim}
\title{Estimation function}
\usage{
TemperedEstim(
  TemperedType = c("Classic", "Subordinator", "Normal"),
  EstimMethod = c("ML", "GMM", "Cgmm", "GMC"),
  data,
  theta0 = NULL,
  ComputeCov = FALSE,
  HandleError = TRUE,
  eps = 1e-06,
  algo = NULL,
  regularization = NULL,
  WeightingMatrix = NULL,
  t_scheme = NULL,
  alphaReg = NULL,
  t_free = NULL,
  subdivisions = NULL,
  IntegrationMethod = NULL,
  randomIntegrationLaw = NULL,
  s_min = NULL,
  s_max = NULL,
  ncond = NULL,
  IterationControl = NULL,
  ...
)
}
\arguments{
\item{TemperedType}{A String. Either "Classic", "Subordinator", or "Normal"}

\item{EstimMethod}{A String. Either "ML", "GMM", "Cgmm", or "GMC".}

\item{data}{Data used to perform the estimation: numeric vector of length n.}

\item{theta0}{A vector of numeric values corresponding to the pattern of the
\code{TemperedType}.}

\item{ComputeCov}{Logical flag: If set to TRUE, the asymptotic covariance
matrix is computed. \code{FALSE} by default.}

\item{HandleError}{Logical flag: If set to \code{TRUE} and if an error occurs
during the estimation procedure, the computation will carry on and NA will be
returned. Useful for Monte Carlo simulations.\code{TRUE} by default.}

\item{eps}{Numerical error tolerance. \code{1e-06} by default.}

\item{algo}{algorithm: For GMM: \code{"2SGMM"} is the two step GMM proposed
by Hansen (1982). \code{"CueGMM"} and \code{"ITGMM"} are respectively the
continuous updated and the iterative GMM proposed by Hansen, Eaton et Yaron
(1996) and adapted to the continuum case. For GMC: \code{"2SGMC", "CueGMC"}.
For Cgmm: \code{"2SCgmm", "CueCgmm", ...}.}

\item{regularization}{regularization scheme to be used for moment methods, one of
\code{"Tikhonov"} (Tikhonov), \code{"LF"} (Landweber-Fridmann) and
\code{"cut-off"} (spectral cut-off).}

\item{WeightingMatrix}{type of weighting matrix used to compute the
objective function for the GMM and GMC methods, one of \code{"OptAsym"} (the optimal asymptotic),
\code{"DataVar"} (the data driven, only for GMM) and \code{"Id"} (the identity matrix).}

\item{t_scheme}{scheme used to select the points for the GMM method where the moment conditions
are evaluated, one of \code{"equally"} (equally placed), \code{"NonOptAr"}
(non optimal arithmetic placement), \code{"uniformOpt"}
(uniform optimal placement), \code{"ArithOpt"} (arithmetic optimal
placement), \code{"Var Opt"} (optimal variance placement) and \code{"free"}
(users need to pass their own set of points in ...).}

\item{alphaReg}{value of the regularisation parameter; numeric. Example Value could be ==0.01.}

\item{t_free}{sequence, if \code{t_scheme=="free"}.}

\item{subdivisions}{Number of subdivisions used to compute the different
integrals involved in the computation of the objective function for the Cgmm method (to
minimise); numeric.}

\item{IntegrationMethod}{Numerical integration method to be used to
approximate the (vectorial) integrals for the Cgmm method. Users can choose between "Uniform"
discretization or the "Simpson"'s rule (the 3-point Newton-Cotes quadrature
rule).}

\item{randomIntegrationLaw}{Probability measure associated to the Hilbert
space spanned by the moment conditions for the Cgmm method.}

\item{s_min, s_max}{Lower and Upper bounds of the interval where the moment
conditions are considered for the Cgmm method; numeric.}

\item{ncond}{Integer. Number of moment conditions (until order \code{ncond}) for the GMC method.
Must not be less than 3 for TSS, 6 for CTS, 5 for NTS.}

\item{IterationControl}{only used if algo = "IT..." or algo = "Cue..."
to control the iterations. See Details.}

\item{...}{Other arguments to be passed to the estimation function or the
asymptotic confidence level.}
}
\value{
Object of a estim-class. See details for more information.
}
\description{
Main estimation function for the tempered stable subordinator distribution
(TSS), the classical tempered stable distribution (CTS), and the normal
tempered stable distribution (NTS). It allows the user to select the
preferred estimation method and several related options.
}
\details{
\strong{TemperedType} Detailed documentation of the individual tempered
stable distributions can be viewed in the respective characteristic function.
Use \code{\link[=charTSS]{charTSS()}}, \code{\link[=charCTS]{charCTS()}}, or \code{\link[=charNTS]{charNTS()}}.

\strong{Estimfct} Additional parameters are needed for different estimation
functions. These are listed below for each function. The list of additional
parameters starts after the parameter \code{eps} in the parameter list.
\describe{
\item{For ML:}{ See usage of Maximum likelihood estimation in Kim et al.
(2008). No additional parameters are needed.}
\item{For GMM:}{Generalized Method of Moments by Feuerverger (1981).
The parameters \code{algo, alphaReg, regularization, WeightingMatrix, and
  t_scheme} must be specified.

Parameter \code{t_scheme}: One of the most important features of this
method is that it allows the user to choose how to place the points where
the moment conditions are evaluated. One can choose among 6 different
options. Depending on the option, further parameters have to be passed.
\describe{
\item{"equally":}{equally placed points in \code{min_t,max_t}. When
provided, user's \code{min_t} and \code{max_t} will be used (when
\code{Coinstrained == FALSE}).
}
\item{"NonOptAr":}{non optimal arithmetic placement.
}
\item{"uniformOpt":}{uniform optimal placement.
}
\item{"ArithOpt":}{arithmetic optimal placement.
}
\item{"Var Opt":}{optimal variance placement as explained above.
}
\item{"free":}{user needs to pass own set of points in \code{t_free}.
}
}

Parameter \code{WeightingMatrix}: One can choose among 3 different options:
\describe{
\item{"OptAsym":}{the optimal asymptotic choice.
}
\item{"DataVar":}{the covariance matrix of the data provided.
}
\item{"Id":}{the identity matrix.
}
}
}
\item{For Cgmm:}{Continuum Generalized Methods of Moments by Carrasco &
Kotchoni (2017). The parameters \code{algo, alphaReg, subdivisions,
  IntegrationMethod, randomIntegrationLaw, s_min, and s_max} must be
specified.
}
\item{For GMC:}{Generalized Method of Cumulants (GMC) by Massing, T.
(2022). The parameters \code{algo, alphaReg, regularization,
   WeightingMatrix, and ncond} must be specified.
}
}

\strong{Estim-Class} Class storing all the information about the estimation
method; output of this function.

\strong{Slots of the return class}
\describe{
\item{par:}{Object of class "\code{numeric}"; Value of the estimated
parameters.}
\item{par0:}{Object of class "\code{numeric}"; Initial guess for the
parameters.}
\item{vcov:}{Object of class "\code{matrix}" representing the covariance
matrix.}
\item{confint:}{Object of class "\code{matrix}" representing the confidence
interval computed at a specific level (attribute of the object).}
\item{data:}{Object of class "\code{numeric}" used to compute the
estimation.}
\item{sampleSize:}{Object of class "\code{numeric}" ; length of the data.}
\item{others:}{Object of class "\code{list}" ; more information about the
estimation method.}
\item{duration:}{Object of class "\code{numeric}" ; duration in seconds.}
\item{failure:}{Object of class "\code{numeric}" representing the status of
the procedure: 0 failure or 1 success.}
\item{method:}{Object of class "\code{character}" description of the
parameter used in the estimation.}
}

\strong{IterationControl} If \code{algo = "IT..."} or \code{algo =
"Cue..."} the user can control each iteration by setting up the list
IterationControl which contains the following elements:
\describe{
\item{NbIter}{maximum number of iteration. The loop stops when NBIter is
reached; default = 10.}
\item{PrintIterlogical}{if set to TRUE, the value of the current parameter
estimation is printed to the screen at each iteration; default = TRUE.}
\item{RelativeErrMax}{the loop stops if the relative error between two
consecutive estimation steps is smaller than RelativeErrMax;
default = 1e-3.}
}

Since this package is structurally based on the \strong{"StableEstim"
package by Tarak Kharrat and Georgi N. Boshnakov}, more detailed
documentation can be found in their documentation.
}
\examples{
\donttest{
TemperedEstim(TemperedType = "Classic", EstimMethod = "ML",
               data = rCTS(2,1.5,1,1,1,1,0),
               theta0 = c(1.5,1,1,1,1,0) - 0.1);
TemperedEstim("Subordinator", "GMM", rTSS(20,0.5,1,1), algo = "2SGMM",
              alphaReg = 0.01, regularization = "cut-off",
              WeightingMatrix = "OptAsym", t_scheme = "free",
              t_free = seq(0.1,2,length.out = 12));
TemperedEstim("Normal", "Cgmm", rNTS(20,0.5,1,1,1,0), algo = "2SCgmm",
              alphaReg = 0.01, subdivisions = 50,
              IntegrationMethod = "Uniform", randomIntegrationLaw = "unif",
              s_min = 0, s_max= 1);
TemperedEstim("Subordinator", "GMC", rTSS(20, 0.5, 1, 1), algo = "2SGMC",
              alphaReg = 0.01, WeightingMatrix = "OptAsym",
              regularization = "cut-off", ncond = 8, theta0 = c(0.5,1,1));
}
}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kim, Y. s., Rachev, S. T., Bianchi, M. L. & Fabozzi, F. J. (2008), 'Financial
market models with lévy processes and time-varying volatility'
\doi{10.1016/j.jbankfin.2007.11.004}

Hansen, L. P. (1982), 'Large sample properties of generalized method of
moments estimators' \doi{10.2307/1912775}

Hansen, L. P.; Heaton, J. & Yaron, A. (1996), 'Finite-Sample Properties of
Some Alternative GMM Estimators' \doi{10.1080/07350015.1996.10524656}

Carrasco, M. & Kotchoni, R. (2017), 'Efficient estimation using the
characteristic function' \doi{10.1017/S0266466616000025}

Kuechler, U. & Tappe, S. (2013), 'Tempered stable distribution and processes'
\doi{10.1016/j.spa.2013.06.012}

Feuerverger, A. & McDunnough, P. (1981), 'On the efficiency of empirical
characteristic function procedures'
\doi{10.1111/j.2517-6161.1981.tb01143.x}
}
\seealso{
\url{https://github.com/GeoBosh/StableEstim/blob/master/R/Simulation.R}
}
