% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{rTSS}
\alias{rTSS}
\title{Function to generate random variates of the TSS distribution.}
\usage{
rTSS(
  n,
  alpha = NULL,
  delta = NULL,
  lambda = NULL,
  theta = NULL,
  methodR = "AR",
  k = 10000
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{theta}{Parameters stacked as a vector.}

\item{methodR}{A String. Either "AR" or "SR".}

\item{k}{integer: the level of truncation, if \code{methodR == "SR"}. 10000
by default.}
}
\value{
Generates \code{n} random numbers.
}
\description{
Generates \code{n} random numbers distributed according
of the tempered stable subordinator distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambda)}. Either provide the parameters
\code{alpha}, \code{delta}, \code{lambda} individually OR provide \code{theta}.
"AR" stands for the Acceptance-Rejection Method and "SR" for a truncated infinite shot
noise series representation. "AR" is the standard method used.
For more details, see references.
}
\examples{
rTSS(100,0.5,1,1)
rTSS(100,0.5,1,1,NULL,"SR",50)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kawai, R & Masuda, H (2011), 'On simulation of tempered stable random
variates' \doi{10.1016/j.cam.2010.12.014}
}
