% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tEIGdwht.R
\name{tEIGdwht}
\alias{tEIGdwht}
\title{Eigenvalue decomposition of 3-mode tensor using the discrete Walsh Hadley transform.}
\usage{
tEIGdwht(tnsr)
}
\arguments{
\item{tnsr, }{a 3-mode S3 tensor class object (\eqn{n} x \eqn{n} x \eqn{k})}
}
\value{
P, tensor of Eigenvectors (\eqn{n} x \eqn{n} x \eqn{k})

D, diagonal tensor of Eigenvalues (\eqn{n} x \eqn{n} x \eqn{k})
}
\description{
Eigenvalue decomposition of 3-mode tensor using the discrete Walsh Hadley transform.
}
\examples{
T <- t_rand(modes=c(2,2,4))
print(tEIGdwht(T))
}
\references{
K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
