% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApplyFwer.R
\name{ApplyFwerCor_oracle}
\alias{ApplyFwerCor_oracle}
\title{Applies an oracle version of MaxTinfty procedure described in Drton & Perlman (2007) for correlation testing.}
\usage{
ApplyFwerCor_oracle(data, corr_theo, alpha = 0.05,
  stat_test = "empirical", method = "MaxTinfty", Nboot = 1000,
  stepdown = TRUE, vect = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{corr_theo}{true matrix of corrlations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{\eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{\eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'gaussian'}{\eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{method}{only 'MaxTinfty' implemented}

\item{Nboot}{number of iterations for Monte-Carlo of bootstrap quantile evaluation}

\item{stepdown}{logical, if TRUE a stepdown procedure is applied
if FALSE, returns an array containing rows and columns of significative correlations}

\item{vect}{optional, logical, if TRUE returns a vector of TRUE/FALSE values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing rows and columns of significative correlations}
}
\value{
Returns the list of significative correlations according to the multiple testing procedure applied
Oracle estimation of the quantile is used, based on the true correlation matrix
}
\description{
Applies oracle MaxTinfty procedure described in Drton & Perlman (2007) which controls asymptotically the FWER
for tests on a correlation matrix. It needs the true correlation matrix.
}
\examples{
n <- 100
p <- 10
corr_theo <- diag(1,p)
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
alpha <- 0.05
res <- ApplyFwerCor_oracle(data,corr_theo,alpha,stat_test='empirical',Nboot=1000,stepdown=FALSE)
}
\references{
Drton, M., & Perlman, M. D. (2007). Multiple testing and error control in Gaussian graphical model selection. Statistical Science, 22(3), 430-449.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.
}
\seealso{
ApplyFwerCor

maxTinftyCor, maxTinftyCor_SD
}
