% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_stat.R
\name{covDcorNorm}
\alias{covDcorNorm}
\title{Returns the theoretical covariance of test statistics for correlation testing.}
\usage{
covDcorNorm(cor_mat, stat_test = "empirical")
}
\arguments{
\item{cor_mat}{a correlation matrix}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{\eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{\eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
}
Notice that 'gaussian' is not available.}
}
\value{
Returns the theoretical covariance of the test statistics.
}
\description{
Returns the theoretical covariance of test statistics for correlation testing.
}
\examples{
p <- 10
corr_theo <- diag(1,p)
corr_theo[2:p,] <- 0.3
corr_theo[,2:p] <- 0.3
covDcorNorm(corr_theo,stat_test='student')
}
\seealso{
covDcor, eval_stat
}
