% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FdrMethods.R
\name{LCTboot}
\alias{LCTboot}
\title{Bootstrap procedure LCT-B proposed by Cai & Liu (2016) for correlation testing.}
\usage{
LCTboot(data, alpha = 0.05, stat_test = "2nd.order", Nboot = 100,
  vect = FALSE, arr.ind = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{\eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{\eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'2nd.order'}{\eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{Nboot}{number of iterations for bootstrap quantile evaluation}

\item{vect}{if TRUE returns a vector of TRUE/FALSE values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing TRUE/FALSE values for each entry of the correlation matrix}

\item{arr.ind}{if TRUE, returns the indexes of the significant correlations, with respect to level alpha}
}
\value{
Returns  \itemize{\item{logicals, equal to TRUE if the corresponding element of the statistic vector is rejected, as a vector or a matrix depending of the value of \code{vect},} \item{an array containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significant, if \code{arr.ind=TRUE}.}}
}
\description{
Bootstrap procedure LCT-B proposed by Cai & Liu (2016) for correlation testing.
}
\examples{
 
n <- 100
p <- 10
corr_theo <- diag(1,p)
corr_theo[1,3] <- 0.5
corr_theo[3,1] <- 0.5
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
alpha <- 0.05
# significant correlations:
LCTboot(data,alpha,stat_test='empirical',Nboot=100,arr.ind=TRUE)
}
\references{
Cai, T. T., & Liu, W. (2016). Large-scale multiple testing of correlations. Journal of the American Statistical Association, 111(513), 229-240.
}
\seealso{
ApplyFdrCor, LCTNorm
}
