% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisticReg.r
\name{LogsticReg}
\alias{LogsticReg}
\title{Logistic Regression (LR) Imputation}
\usage{
LogsticReg(test.data, Mvalue = "NA", max.score = 1)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data. By default max.score=1 (i.e.,binary test data).}
}
\value{
A data frame with all missing responses replaced by integrated imputed values.
}
\description{
This function imputes for all missing responses using logistic regression.
Integrated scores are obtained by rounding imputed values to the closest possible response value.
}
\examples{
 
        LogsticReg(test.data, Mvalue="8",max.score=1)
}

