% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_class.R
\docType{class}
\name{config_Static-class}
\alias{config_Static-class}
\alias{createStaticTestConfig}
\title{createStaticTestConfig}
\usage{
createStaticTestConfig(item_selection = NULL, MIP = NULL)
}
\arguments{
\item{item_selection}{A list containing item selection criteria. This should have the following entries:
\itemize{
  \item{\code{method}} The type of criteria. Accepts \code{MAXINFO, TIF, TCC}.
  \item{\code{info_type}} The type of information. Accepts \code{FISHER}.
  \item{\code{target_location}} A numeric vector containing the locations of target theta points. (e.g. \code{c(-1, 0, 1)})
  \item{\code{target_value}} A numeric vector containing the target values at each theta location. This should have the same length with \code{target_location}. Ignored if method is \code{MAXINFO}.
  \item{\code{target_weight}} A numeric vector containing the weights for each theta location. This should have the same length with \code{targetlocation}. Defaults to a vector of 1s.
}}

\item{MIP}{A list containing solver options. This should have the following entries:
\itemize{
  \item{\code{solver}} The type of solver. Accepts \code{lpsymphony, Rsymphony, gurobi, lpSolve, Rglpk}.
  \item{\code{verbosity}} Verbosity level of the solver. Defaults to -2.
  \item{\code{time_limit}} Time limit in seconds passed onto the solver. Defaults to 60. Used in solvers \code{lpsymphony, Rsymphony, gurobi, Rglpk}.
  \item{\code{gap_limit}} Termination criterion. Gap limit in relative scale passed onto the solver. Defaults to .05. Used in solver \code{gurobi}.
  \item{\code{gap_limit_abs}} Termination criterion. Gap limit in absolute scale passed onto the solver. Defaults to .05. Used in solver \code{lpsymphony, Rsymphony}.
  \item{\code{obj_tol}} Termination criterion. Tolerance on target objective value in absolute difference scale. Defaults to .05. Ignored if method is \code{MAXINFO}.
}}
}
\description{
Create a \code{\linkS4class{config_Static}} object for Static (fixed-form) test assembly.
}
\examples{
cfg1 <- createStaticTestConfig(
  list(
    method = "MAXINFO",
    info_type = "FISHER",
    target_location = c(-1, 0, 1),
    target_weight = c(1, 1, 1)
  )
)

cfg2 <- createStaticTestConfig(
  list(
    method = "TIF",
    info_type = "FISHER",
    target_location = c(-1, 0, 1),
    target_weight = c(1, 1, 1),
    target_value = c(8, 10, 12)
  )
)

cfg3 <- createStaticTestConfig(
  list(
    method = "TCC",
    info_type = "FISHER",
    target_location = c(-1, 0, 1),
    target_weight = c(1, 1, 1),
    target_value = c(10, 15, 20)
  )
)
}
