% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadItemPool}
\alias{loadItemPool}
\title{Load item paramaters}
\usage{
loadItemPool(file, ipar = NULL, se_file = NULL)
}
\arguments{
\item{file}{File path of a .csv file containing item parameters. The file content should at least include columns 'ID' and 'MODEL'.}

\item{ipar}{A data.frame containing the item parameters. If supplied, this argument is used over 'file'.}

\item{se_file}{File path of a .csv file containing standard errors.}
}
\value{
An \linkS4class{item_pool} object.
}
\description{
Read item parameters from a .csv file or a data.frame and create an \linkS4class{item_pool} class.
}
\examples{
## Write to tempdir() and clean afterwards
f <- file.path(tempdir(), "itempool_science.csv")
write.csv(itempool_science_raw, f, row.names = FALSE)
itempool_science <- loadItemPool(f)
file.remove(f)

}
\seealso{
\link{dataset_science} for example usage.
}
