% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_functions.R
\name{getSolutionAttributes}
\alias{getSolutionAttributes}
\title{Retrieve constraints-related attributes from solution}
\usage{
getSolutionAttributes(constraints, item_idx, all_values = FALSE)
}
\arguments{
\item{constraints}{a \code{\linkS4class{constraints}} object.}

\item{item_idx}{item indices from a solution.}

\item{all_values}{if \code{TRUE}, return all values as-is without taking the mean when there are multiple values. If \code{FALSE}, return the mean when there are multiple values.
This has an effect when there is a constraint on items per stimulus, where there are multiple values of number of items per stimulus.
In this case, if \code{TRUE}, the number of items for every stimuli are returned as-is. If \code{FALSE}, the average number of items across stimuli is returned.
(default = \code{FALSE})}
}
\value{
\itemize{
  \item{If \code{all_values == FALSE}, \code{\link{getSolutionAttributes}} returns a \code{\link{data.frame}} containing constraints data and their associated attributes.}
  \item{If \code{all_values == TRUE}, \code{\link{getSolutionAttributes}} returns a \code{\link{list}} containing attributes associated to each constraint.}
}
}
\description{
\code{\link{getSolutionAttributes}} is a helper function for retrieving constraints-related attributes from a solution.
}
\examples{
item_idx <-
  c( 29,  33,  26,  36,  34,
    295, 289, 296, 291, 126,
    133, 124, 134, 129,  38,
     47,  39,  41,  46,  45,
    167, 166, 170, 168, 113,
    116, 119, 117, 118, 114)

getSolutionAttributes(constraints_reading, item_idx, FALSE)
getSolutionAttributes(constraints_reading, item_idx, TRUE)

}
