% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions1.R, R/test_func_apply.R
\name{branin}
\alias{OTL_Circuit}
\alias{banana}
\alias{borehole}
\alias{branin}
\alias{currin1991}
\alias{franke}
\alias{gaussian1}
\alias{lim2002}
\alias{powsin}
\alias{sinumoid}
\alias{sqrtsin}
\alias{test_func_apply}
\alias{waterfall}
\alias{zhou1998}
\title{Test function.}
\usage{
branin(x, scale_it = T, scale_low = c(-5, 0), scale_high = c(10, 15))

borehole(x, scale_it = T, scale_low = c(0.05, 100, 63070, 990, 63.1, 700,
  1120, 9855), scale_high = c(0.15, 50000, 115600, 1110, 116, 820, 1680,
  12045))

franke(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

zhou1998(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

currin1991(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

lim2002(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

banana(x, scale_it = T, scale_low = c(-20, -10), scale_high = c(20, 5))

gaussian1(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

sinumoid(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

waterfall(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1))

sqrtsin(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  freq = 2 * pi)

powsin(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0, freq = 2 * pi, pow = 0.7)

OTL_Circuit(x, scale_it = T, scale_low = c(50, 25, 0.5, 1.2, 0.25, 50),
  scale_high = c(150, 70, 3, 2.5, 1.2, 300))

test_func_apply(func, x, scale_it, scale_low, scale_high, noise = 0, ...)
}
\arguments{
\item{x}{Input value, either a matrix whose rows are points or
a vector for a single point. Be careful with 1-D functions.}

\item{scale_it}{Should the data be scaled from [0, 1]^D to
[scale_low, scale_high]? This means the input data is confined
to be in [0, 1]^D, but the function isn't.}

\item{scale_low}{Lower bound for each variable}

\item{scale_high}{Upper bound for each variable}

\item{freq}{Wave frequency for sqrtsin and powsin}

\item{noise}{If white noise should be added, specify the
standard deviation for normal noise}

\item{pow}{Power for powsin}

\item{func}{A function to evaluate}

\item{...}{Additional parameters for func}
}
\value{
Function values at x
}
\description{
branin: A function.
2 dimensional function.

borehole: A function estimating water flow through a borehole.
8 dimensional function.

franke: A function.
2 dimensional function.

zhou1998: A function.
2 dimensional function.

currin1991: A function.
2 dimensional function.

lim2002: Some function?
2 dimensional function.

banana: A banana shaped function.
2 dimensional function.

gaussian1: A Gaussian function centered at 0.5.
Any dimensional function.

sinumoid: A sinusoid added to a sigmoid function.
2 dimensional function.

waterfall: A sinusoid added to a sigmoid function.
2 dimensional function.

sqrtsin: A square root of a sine function.
Any dimensional function.

powsin: A sine function raised to a power keeping its original sign.
Any dimensional function.

OTL_Circuit: OTL Circuit.
6 dimensional function.

General function for evaluating a test function
}
\examples{
branin(runif(2))
branin(matrix(runif(20), ncol=2))
borehole(runif(8))
borehole(matrix(runif(80), ncol=8))
franke(runif(2))
zhou1998(runif(2))
currin1991(runif(2))
lim2002(runif(2))
banana(runif(2))
x <- y <- seq(0, 1, len=100)
z <- outer(x, y, Vectorize(function(a, b){banana(c(a, b))}))
contour(x, y, z)
gaussian1(runif(2))
sinumoid(runif(2))
x <- y <- seq(0, 1, len=100)
z <- outer(x, y, Vectorize(function(a, b){sinumoid(c(a, b))}))
contour(x, y, z)
waterfall(runif(2))
sqrtsin(runif(1))
curve(sqrtsin(matrix(x,ncol=1)))
powsin(runif(1))#,pow=2)
OTL_Circuit(runif(6))
OTL_Circuit(matrix(runif(60),ncol=6))
x <- matrix(seq(0,1,length.out=10), ncol=1)
y <- test_func_apply(sin, x, TRUE, 0, 2*pi, .05)
plot(x,y)
curve(sin(2*pi*x), col=2, add=TRUE)
}

