% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{extract_xy}
\alias{extract_xy}
\title{Extractor function that extracts the (x, y) pairs in the plot and puts them
as columns in a data.frame, with colnames "x" and "y"}
\usage{
extract_xy(data)
}
\arguments{
\item{data}{Provided internally, users don't need to provide this.}
}
\value{
A tibble with the "x" column corresponding to the x-values in the
plot, and a "y" column corresponding to the y-values in the plot.
}
\description{
Extractor function that extracts the (x, y) pairs in the plot and puts them
as columns in a data.frame, with colnames "x" and "y"
}
\details{
Since this extractor returns an entire data.frame, the extractor
function cannot use ordinary summary statistics like \code{mean}, \code{median} etc.
If you want to do that, look into the other extractors. Instead, you will
need summary functions that pull out a single value from the data.frame.
}
\examples{
report <- load_multiqc(
  system.file("extdata", "wgs/multiqc_data.json", package = "TidyMultiqc"),
  sections = "plots",
  plot_opts = list(
    qualimap_genome_fraction = list(
      extractor = extract_xy,
      summary = list(
        `\%Q30` = purrr::partial(summary_extract_df, row_select = x == 30)
      )
    )
  )
)
}
\seealso{
Other extractors: 
\code{\link{extract_histogram}()},
\code{\link{extract_ignore_x}()}
}
\concept{extractors}
