% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.analysis.R
\name{ts.analysis}
\alias{ts.analysis}
\title{Time series analysis results for OBEU Time series}
\usage{
ts.analysis(tsdata, x.order=NULL, prediction.steps=1, tojson=T)
}
\arguments{
\item{tsdata}{The input univariate time series data}

\item{x.order}{An integer vector of length 3 specifying the order of the Arima model}

\item{prediction.steps}{The number of prediction steps}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A json string with the parameters:

\itemize{
\item acf.param
\itemize{
 \item acf.parameters: 
 \itemize{ 
 \item acf The estimated acf values of the input time series
 \item acf.lag The lags at which the acf is estimated
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 
 \item pacf.parameters: 
 \itemize{ 
 \item pacf The estimated pacf values of the input time series
 \item pacf.lag The lags at which the pacf is estimated
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 
 \item acf.residuals.parameters: 
 \itemize{ 
 \item acf.res The estimated acf values of the model residuals
 \item acf.res.lag The lags at which the acf is estimated of the model residuals
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}
 
 \item pacf.residuals.parameters: 
 \itemize{ 
 \item pacf.res The estimated pacf values of the model residuals
 \item pacf.res.lag The lags at which the pacf is estimated of the model residuals
 \item confidence.interval.up The upper limit of the confidence interval
 \item confidence.interval.low The lower limit of the confidence interval}}
 
\item param
\itemize{
\item stl.plot: 
\itemize{
 \item trend The estimated trend component
 \item trend.ci.up The estimated up limit for trend component (for non seasonal time series)
 \item trend.ci.low The estimated low limit for trend component (for non seasonal time series)
 \item seasonal The estimated seasonal component
 \item remainder The estimated remainder component
 \item time The time of the series was sampled}

\item stl.general:
\itemize{
 \item stl.degree The degree of fit
 \item degfr The effective degrees of freedom for non seasonal time series
 \item degfr.fitted The fitted degrees of freedom for non seasonal time series
 \item fitted The model's fitted values }
 
\item residuals The residuals of the model (fitted innovations)

\item compare: 
 \itemize{
 \item arima.order The Arima order for seasonal time series
 \item arima.coef A vector of AR, MA and regression coefficients
 \item arima.coef.se The standard error of the coefficients 
 \item covariance.coef The matrix of the estimated variance of the coefficients 
 \item resid.variance The residuals variance
 \item not.used.obs The number of not used observations for the fitting  
 \item used.obs The used observations for the fitting
 \item loglik The maximized log-likelihood (of the differenced data), or the approximation to it used
 \item aic The AIC value corresponding to the log-likelihood
 \item bic The BIC value corresponding to the log-likelihood
 \item gcv The generalized cross-validation statistic   time series
 \item aicc The second-order Akaike Information Criterion corresponding to the log-likelihood
 for seasonal time series}}

\item forecasts
\itemize{
\item ts.model a string indicating the arima orders
\item data_year The time that time series data were sampled
\item data The time series values
\item predict_time The time that defined by the prediction_steps parameter
\item predict_values The predicted values that defined by the prediction_steps parameter
\item up80 The upper limit of the 80\% predicted confidence interval
\item low80 The lower limit of the 80\% predicted confidence interval
\item up95 The upper limit of the 95\% predicted confidence interval
\item low95 The lower limit of the 95\% predicted confidence interval}
}
}
\description{
Univariate time series analysis for short and long time series data using the appropriate model.
}
\details{
This function automatically tests for stationarity of the input time series data using \code{\link{ts.stationary.test}}
function. Depending the nature of the time series data and the stationary tests there are four branches:
a.)short and non seasonal, b.)short and seasonal, c.)long and non seasonal and d.)long and seasonal.
For branches a and c \code{\link{ts.non.seas.model}} is used and for b and d \code{\link{ts.seasonal.model}} is used.

This function also decomposes both seasonal and non seasonal time series through \code{\link{ts.non.seas.decomp}} and 
\code{\link{ts.seasonal.decomp}} and forecasts h steps ahead the user selected(default h=1) using \code{\link{ts.forecast}}.
}
\examples{
ts.analysis(Athens_draft_ts, prediction.steps=3)

}
\seealso{
\code{\link{ts.stationary.test}}, \code{\link{ts.acf}}, \code{\link{ts.seasonal.model}}, \code{\link{ts.seasonal.decomp}},
\code{\link{ts.non.seas.model}}, \code{\link{ts.non.seas.decomp}}, \code{\link{ts.forecast}}
}
\author{
Kleanthis Koupidis
}
