\name{elbow.tree}
\alias{elbow.tree}

\title{
Finding the Final Tree using the Elbow Method
}
\description{
\code{elbow.tree} is like \code{final.tree}, but instead of using the minimum cost it uses the 'elbow' of the costs. It is similar to the elbow AIC or BIC approaches in the literature.
}
\usage{
elbow.tree(nodetree=nodetree, subtrees=subtrees, omega, alphac=2)
}

\arguments{
  \item{nodetree}{
Fully grown tree from the original data. Output from \code{\link{output.coxphout}}
}
  \item{subtrees}{
Pruned subtrees from the original data. Output from \code{\link{prune}}
}
  \item{omega}{
	Bias (i.e. third index of the output) from \code{\link{bootstrap}}. Look at the value section of \code{\link{bootstrap}} for more information.
}
  \item{alphac}{
	Predetermined penalty parameter
}
}
\details{
	One can take the output (table) generated by this function and plot the (penalized) bias-corrected cost of each subtrees, then (visually) identify the 'elbow' as the selected subtree.
}
\value{
\item{subtree }{output from \code{prune} with an additional column 'cost' that contains bootstrap estimate of each subtree}
\item{cost.p }{This column contains the (penalized) bias-corrected cost of each subtree}
}

\examples{
\dontrun{
data('alcohol')
require(survival)

coxtree <- coxph.tree(alcohol[,'time'], alcohol[,'event'], 
                      x = alcohol[,'alc', drop = FALSE], D = 4)
nodetree <- output.coxphout(coxtree)

subtrees <- prune(nodetree)

store.mult.cont <- bootstrap(B=20, nodetree, subtrees, alcohol[,'time'],
                                alcohol[,'event'], x = alcohol[,'alc', drop = FALSE], 
                                D=4,minfail=20, alphac=2)
                                
Balph <- 0.5 * 2 * log(nrow(alcohol))                                
elbow.tree <- elbow.tree(nodetree, subtrees, store.mult.cont[[3]], alphac= Balph)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
