% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{convert_to_date}
\alias{convert_to_date}
\title{Convert dates to standard format}
\usage{
convert_to_date(date_vector, output_type = c("date", "datetime"))
}
\arguments{
\item{date_vector}{A character vector containing dates in various formats.}

\item{output_type}{Type of object to return: "date" for Date, "datetime" for POSIXct.}
}
\value{
A vector of \code{Date} or \code{POSIXct} objects, or \code{NA} if the date cannot be converted.
}
\description{
Converts a vector of dates in various formats to a standard date format.
The function tries to parse each date using predefined formats and returns
the first valid date found for each entry. If a date cannot be interpreted,
it is assigned as \code{NA}.
}
\examples{
dates <- c("2025-04-10", "10/04/2025", "April 10, 2025")
converted_dates <- convert_to_date(dates)
print(converted_dates)

}
