#' @title Aliases
#' @name aliases
#' @description Aliases more pleasing to use in a dplyr pipeline:
#' \tabular{ll}{
#' \code{brackets}        \tab \code{`[[`}           \cr
#' \code{dollar}          \tab \code{`$`}            \cr
#' \code{is_in}           \tab \code{`\%in\%`}       \cr
#' \code{and}             \tab \code{`&`}            \cr
#' \code{or}              \tab \code{`|`}            \cr
#' \code{equals}          \tab \code{`==`}           \cr
#' \code{is_gt}           \tab \code{`>`}            \cr
#' \code{is_geq}          \tab \code{`>=`}           \cr
#' \code{is_lt}           \tab \code{`<`}            \cr
#' \code{is_leq}          \tab \code{`<=`}           \cr
#' \code{not}             \tab \code{`!`}            \cr
#' \code{set_colnames}    \tab \code{`colnames<-`}   \cr
#' \code{set_rownames}    \tab \code{`rownames<-`}   \cr
#' \code{set_names}       \tab \code{`names<-`}      \cr
#' \code{set_attributes}  \tab \code{`attributes<-`} \cr
#' \code{set_attr}        \tab \code{`attr<-`}       \cr
#' }
#' 
#' @rdname aliases
#' @usage NULL
#' @export
brackets <- `[[`

#' @rdname aliases
#' @usage NULL
#' @export
dollar <- `$`

#' @rdname aliases
#' @usage NULL
#' @export
is_in <- `%in%`

#' @rdname aliases
#' @usage NULL
#' @export
and <- `&`

#' @rdname aliases
#' @usage NULL
#' @export
or <- `|`

#' @rdname aliases
#' @usage NULL
#' @export
equals <- `==`

#' @rdname aliases
#' @usage NULL
#' @export
is_gt <- `>`

#' @rdname aliases
#' @usage NULL
#' @export
is_geq <- `>=`

#' @rdname aliases
#' @usage NULL
#' @export
is_lt <- `<`

#' @rdname aliases
#' @usage NULL
#' @export
is_leq <- `<=`

#' @rdname aliases
#' @usage NULL
#' @export
not <- `!`

#' @rdname aliases
#' @usage NULL
#' @export
set_colnames <- `colnames<-`

#' @rdname aliases
#' @usage NULL
#' @export
set_rownames <- `rownames<-`

#' @rdname aliases
#' @usage NULL
#' @export
set_names <- `names<-`

#' @rdname aliases
#' @usage NULL
#' @export
set_class <- `class<-`

#' @rdname aliases
#' @usage NULL
#' @export
set_attr <- `attr<-`

#' @rdname aliases
#' @usage NULL
#' @export
set_attributes <- `attributes<-`
