% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayDescription.R
\name{pathway_description}
\alias{pathway_description}
\title{Describe Genes Present in Selected Pathways}
\usage{
pathway_description(GO, selected_pathways_names, enrich_data)
}
\arguments{
\item{GO}{A character vector of gene symbols.}

\item{selected_pathways_names}{A character vector specifying the names of selected pathways.}

\item{enrich_data}{A data frame containing pathway enrichment analysis results.}
}
\value{
A data frame with columns "Symble" (gene symbol), "Description" (pathway description), and "Exists" (1 if gene is present, 0 otherwise).
}
\description{
This function identifies genes present in selected pathways based on gene enrichment analysis results.
}
\examples{
GO <- c("Gene1", "Gene2", "Gene3", "Gene4", "Gene5")
# Simulated enrichment analysis data
enrich_data <- data.frame(
  ID = c("Pathway1", "Pathway2", "Pathway3", "Pathway4"),
  Description = c("Apoptosis", "Cell Cycle", "Signal Transduction", "Metabolism"),
  geneID = c("Gene1/Gene3", "Gene2/Gene4", "Gene1/Gene2/Gene3", "Gene5"),
  Count = c(2, 2, 3, 1),
  stringsAsFactors = FALSE
)

# Example usage
result <- pathway_description(GO,
                              selected_pathways_names="Apoptosis",
                              enrich_data)

}
