% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTcgaExp.R
\name{get_tcga_exp}
\alias{get_tcga_exp}
\title{TCGA Expression Data Processing}
\usage{
get_tcga_exp(
  counts_file_path,
  gene_probes_file_path,
  phenotype_file_path,
  output_file_path
)
}
\arguments{
\item{counts_file_path}{File path to the counts data (usually in the form of a large matrix with gene expression data).}

\item{gene_probes_file_path}{File path containing the gene probes data.}

\item{phenotype_file_path}{File path to the phenotype data, which includes various sample attributes.}

\item{output_file_path}{Path where the output files, distinguished between tumor and normal, will be saved.}
}
\value{
A list containing matrices for tumor and normal expression data.
}
\description{
This function processes expression data and phenotype information, separates tumor and normal samples,
and saves the results into different files. It's specifically designed for data obtained from TCGA.
}
\note{
IMPORTANT: This function assumes that the input files follow a specific format and structure, typically found in TCGA data releases.
Users should verify their data's compatibility. Additionally, the function does not perform error checking on the data's content,
which users should handle through proper preprocessing.

CRITICAL: The 'output_file_path' parameter must end with '.rds' to be properly recognized by the function. It is also highly recommended
that the path includes specific identifiers related to the target samples, as the function will create further subdivisions in the specified
path for tumor or normal tissues. Please structure the 'output_file_path' following this pattern: './your_directory/your_sample_type.exp.rds'.
}
\examples{
counts_file <- system.file("extdata", "TCGA-SKCM.htseq_counts_test.tsv", package = "TransProR")
gene_probes_file <- system.file("extdata",
                                "TCGA_gencode.v22.annotation.gene.probeMap_test",
                                package = "TransProR")
phenotype_file <- system.file("extdata", "TCGA-SKCM.GDC_phenotype_test.tsv", package = "TransProR")
ouput_file <- file.path(tempdir(), "SKCM_Skin_TCGA_exp_test.rds")

SKCM_exp <- get_tcga_exp(
  counts_file_path = counts_file,
  gene_probes_file_path = gene_probes_file,
  phenotype_file_path = phenotype_file,
  output_file_path = ouput_file
)
head(SKCM_exp[["tumor_tcga_data"]])[1:5, 1:5]
head(SKCM_exp[["normal_tcga_data"]], n = 10) # Because there is only one column.
}
\author{
Dongyue Yu
}
