% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePathways.R
\name{computePathways}
\alias{computePathways}
\title{computePathways}
\usage{
computePathways(
  cohorts,
  cohortTableName,
  cdm = NULL,
  connectionDetails = NULL,
  cdmSchema = NULL,
  resultSchema = NULL,
  tempEmulationSchema = NULL,
  includeTreatments = "startDate",
  periodPriorToIndex = 0,
  minEraDuration = 0,
  splitEventCohorts = NULL,
  splitTime = NULL,
  eraCollapseSize = 30,
  combinationWindow = 30,
  minPostCombinationDuration = 30,
  filterTreatments = "First",
  maxPathLength = 5
)
}
\arguments{
\item{cohorts}{(\code{data.frame()})\cr
Data frame containing the following columns and data types:
\describe{
\item{cohortId \code{numeric(1)}}{Cohort ID's of the cohorts to be used in the cohort table.}
\item{cohortName \code{character(1)}}{Cohort names of the cohorts to be used in the cohort table.}
\item{type \code{character(1)} ["target", "event', "exit"]}{Cohort type, describing if the cohort is a target, event, or exit cohort}
}}

\item{cohortTableName}{(\code{character(1)})\cr
Cohort table name.}

\item{cdm}{(\code{CDMConnector::cdm_from_con()}: \code{NULL})\cr
Optional; Ignores \code{connectionDetails}, \code{cdmSchema}, and \code{resultSchema}.}

\item{connectionDetails}{(\code{DatabaseConnector::createConnectionDetails()}: \code{NULL})\cr
Optional; In congruence with \code{cdmSchema} and \code{resultSchema}. Ignores \code{cdm}.}

\item{cdmSchema}{(\code{character(1)}: \code{NULL})\cr
Optional; In congruence with \code{connectionDetails} and \code{resultSchema}. Ignores \code{cdm}.}

\item{resultSchema}{(\code{character(1)}: \code{NULL})\cr
Optional; In congruence with \code{connectionDetails} and \code{cdmSchema}. Ignores \code{cdm}.}

\item{tempEmulationSchema}{Schema used to emulate temp tables}

\item{includeTreatments}{(\code{character(1)}: \code{"startDate"})\cr
\describe{
\item{\code{"startDate"}}{Include treatments after the target cohort start date and onwards.}
\item{\code{"endDate"}}{Include treatments before target cohort end date and before.}
}}

\item{periodPriorToIndex}{(\code{integer(1)}: \code{0})\cr
Number of days prior to the index date of the target cohort | that event
cohorts are allowed to start}

\item{minEraDuration}{(\code{integer(1)}: \code{0})\cr
Minimum time an event era should last to be included in analysis}

\item{splitEventCohorts}{(\code{character(n)}: \code{""})\cr
Specify event cohort to split in acute (< X days) and therapy (>= X days)}

\item{splitTime}{(\code{integer(1)}: \code{30})\cr
Specify number of days (X) at which each of the split event cohorts should
be split in acute and therapy}

\item{eraCollapseSize}{(\code{integer(1)}: \code{30})\cr
Window of time between which two eras of the same event cohort are collapsed
into one era}

\item{combinationWindow}{(\code{integer(1)}: \code{30})\cr
Window of time two event cohorts need to overlap to be considered a
combination treatment}

\item{minPostCombinationDuration}{(\code{integer(1)}: \code{30})\cr
Minimum time an event era before or after a generated combination treatment
should last to be included in analysis}

\item{filterTreatments}{(\code{character(1)}: \code{"First"} ["first", "Changes", "all"])\cr
Select first occurrence of (‘First’); changes between (‘Changes’); or all
event cohorts (‘All’).}

\item{maxPathLength}{(\code{integer(1)}: \code{5})\cr
Maximum number of steps included in treatment pathway}
}
\value{
(\code{Andromeda::andromeda()})
\link[Andromeda]{andromeda} object containing non-sharable patient level
data outcomes.
}
\description{
Compute treatment patterns according to the specified parameters within
specified cohorts.
}
\examples{
\donttest{
ableToRun <- all(
  require("CirceR", character.only = TRUE, quietly = TRUE),
  require("CDMConnector", character.only = TRUE, quietly = TRUE),
  require("TreatmentPatterns", character.only = TRUE, quietly = TRUE),
  require("dplyr", character.only = TRUE, quietly = TRUE)
)

if (ableToRun) {
  library(TreatmentPatterns)
  library(CDMConnector)
  library(dplyr)

  withr::local_envvar(
    R_USER_CACHE_DIR = tempfile(),
    EUNOMIA_DATA_FOLDER = Sys.getenv("EUNOMIA_DATA_FOLDER", unset = tempfile())
  )

  tryCatch({
    if (Sys.getenv("skip_eunomia_download_test") != "TRUE") {
      CDMConnector::downloadEunomiaData(overwrite = TRUE)
    }
  }, error = function(e) NA)

  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
  cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")

  cohortSet <- readCohortSet(
    path = system.file(package = "TreatmentPatterns", "exampleCohorts")
  )

  cdm <- generateCohortSet(
    cdm = cdm,
    cohortSet = cohortSet,
    name = "cohort_table"
  )

  cohorts <- cohortSet \%>\%
    # Remove 'cohort' and 'json' columns
    select(-"cohort", -"json") \%>\%
    mutate(type = c("event", "event", "event", "event", "exit", "event", "event", "target")) \%>\%
    rename(
      cohortId = "cohort_definition_id",
      cohortName = "cohort_name",
    ) \%>\%
    select("cohortId", "cohortName", "type")

  outputEnv <- computePathways(
    cohorts = cohorts,
    cohortTableName = "cohort_table",
    cdm = cdm
  )

  Andromeda::close(outputEnv)
  DBI::dbDisconnect(con, shutdown = TRUE)
}
}
}
