% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_utilities.R
\name{CompareAll}
\alias{CompareAll}
\title{Distances between each pair of trees}
\usage{
CompareAll(x, Func, FUN.VALUE = Func(x[[1]], x[[1]]), ...)
}
\arguments{
\item{x}{List of trees, in the format expected by \code{Func()}.}

\item{Func}{distance function returning distance between two trees,
e.g. \code{\link[phangorn:treedist]{path.dist()}}.}

\item{FUN.VALUE}{Format of output of \code{Func()}, to be passed to \code{\link[=vapply]{vapply()}}.
If unspecified, calculated by running \code{Func(x[[1]], x[[1]])}.}

\item{\dots}{Additional parameters to pass to \code{Func()}.}
}
\value{
\code{CompareAll()} returns a distance matrix of class \code{dist} detailing
the distance between each pair of trees.
Identical trees are assumed to have zero distance.
}
\description{
Calculate the distance between each tree in a list, and each other tree
in the same list.
}
\details{
\code{CompareAll()} is not limited to tree comparisons:
\code{Func} can be any symmetric function.
}
\examples{
# Generate a list of trees to compare
library('TreeTools', quietly = TRUE, warn.conflicts = FALSE)
trees <- list(bal1 = BalancedTree(1:8), 
              pec1 = PectinateTree(1:8),
              pec2 = PectinateTree(c(4:1, 5:8)))
  
# Compare each tree with each other tree
CompareAll(trees, NNIDist)
  
# Providing FUN.VALUE yeilds a small speed gain:
dist <- CompareAll(trees, NNIDist, FUN.VALUE = integer(3))
  
# View distances as a matrix
as.matrix(dist$lower)
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{pairwise tree distances}
