% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeDist-package.R
\docType{package}
\encoding{UTF-8}
\name{TreeDist-package}
\alias{TreeDist}
\alias{TreeDist-package}
\title{TreeDist:  Distances between Phylogenetic Trees}
\description{
'TreeDist' is an R package that implements a suite of metrics that quantify the
topological distance between pairs of unweighted phylogenetic trees.
It also includes a simple 'Shiny' application to allow the visualization of
distance-based tree spaces.
}
\details{
'TreeDist' primarily employs metrics in the category of
'generalized Robinson–Foulds distances': they are based on comparing splits
(bipartitions) between trees, and thus reflect the relationship data within
trees, with no reference to branch lengths.
Detailed documentation and usage instructions are
\href{https://ms609.github.io/TreeDist/}{available online} or in the vignettes.
\subsection{Generalized RF distances}{

The \href{https://ms609.github.io/TreeDist/articles/Robinson-Foulds.html}{Robinson–Foulds distance}
simply tallies the number of non-trivial splits (sometimes inaccurately
termed clades, nodes or edges) that occur in both trees -- any splits that are
not perfectly identical contributes one point to the distance score of zero,
however similar or different they are.
By overlooking potential similarities between almost-identical splits,
this conservative approach has undesirable properties.

\href{https://ms609.github.io/TreeDist/articles/Generalized-RF.html}{'Generalized' RF metrics}
generate \emph{matchings} that pair each split in one tree with a similar split
in the other.
Each pair of splits is assigned a similarity score; the sum of these scores in
the optimal matching then quantifies the similarity between two trees.

Different ways of calculating the the similarity between a pair of splits
lead to different tree distance metrics, implemented in the functions below:
\itemize{
\item \href{https://ms609.github.io/TreeDist/reference/TreeDistance.html}{\code{MutualClusteringInfo()}}, \href{https://ms609.github.io/TreeDist/reference/TreeDistance.html}{\code{SharedPhylogeneticInfo()}}
\itemize{
\item Smith (2020) scores matchings based on the amount of information
that one partition contains about the other.  The Mutual Phylogenetic
Information assigns zero similarity to split pairs that cannot
both exist on a single tree; The Mutual
Clustering Information metric is more forgiving, and exhibits more
desirable behaviour; it is the recommended metric for tree comparison.
(Its complement, \href{https://ms609.github.io/TreeDist/reference/TreeDistance.html}{\code{ClusteringInfoDistance()}}, returns a tree
distance.)
}
\item \href{https://ms609.github.io/TreeDist/reference/NyeSimilarity.html}{\code{NyeSimilarity()}}
\itemize{
\item Nye \emph{et al.} (2006) score matchings according to the size of the largest
split that is consistent with both of them, normalized against
the Jaccard index.  This approach is extended by Böcker \emph{et al}. (2013)
with the Jaccard–Robinson–Foulds metric (function
\href{https://ms609.github.io/TreeDist/reference/JaccardRobinsonFoulds.html}{\code{JaccardRobinsonFoulds()}}).
}
\item \href{https://ms609.github.io/TreeDist/reference/MatchingSplitDistance.html}{\code{MatchingSplitDistance()}}
\itemize{
\item Bogdanowicz and Giaro (2012) and  Lin \emph{et al.} (2012) independently proposed
counting the number of 'mismatched' leaves in a pair of splits.
\href{https://ms609.github.io/TreeDist/reference/TreeDistance.html}{\code{MatchingSplitInfoDistance()}}
provides an information-based equivalent (Smith 2020).
}
}

The package also implements the variation of the path distance
proposed by Kendal and Colijn (2016) (function
\href{https://ms609.github.io/TreeDist/reference/KendallColijn.html}{\code{KendallColijn()}}),
approximations of the Nearest-Neighbour Interchange (NNI) distance (function
\href{https://ms609.github.io/TreeDist/reference/NNIDist.html}{\code{NNIDist()}};
following Li \emph{et al.} (1996)), and calculates the size (function
\href{https://ms609.github.io/TreeDist/reference/MASTSize.html}{\code{MASTSize()}}) and
information content (function
\href{https://ms609.github.io/TreeDist/reference/MASTSize.html}{\code{MASTInfo()}}) of the
Maximum Agreement Subtree.

For an implementation of the Tree Bisection and Reconnection (TBR) distance, see
the package '\href{https://ms609.github.io/TBRDist/index.html}{TBRDist}'.
}
}
\section{Tree space analysis}{
Project tree spaces and readily visualize projected landscapes, avoiding
common analytical pitfalls (Smith, forthcoming),
using the inbuilt graphical user interface:\if{html}{\out{<div class="r">}}\preformatted{TreeDist::Project()
}\if{html}{\out{</div>}}

Serious analysts should consult the
\href{https://ms609.github.io/TreeDist/articles/treespace.html}{vignette}
for a command-line interface.
}

\references{
\itemize{
\item \insertRef{Bocker2013}{TreeDist}
\item \insertRef{Bogdanowicz2012}{TreeDist}
\item \insertRef{Kendall2016}{TreeDist}
\item \insertRef{Li1996}{TreeDist}
\item \insertRef{Lin2012}{TreeDist}
\item \insertRef{Nye2006}{TreeDist}
\item \insertRef{SmithDist}{TreeDist}
\item \insertRef{SmithSpace}{TreeDist}
}
}
\seealso{
Further documentation is available in the
\href{https://ms609.github.io/TreeDist/articles/}{package vignettes}, visible from
R using \code{vignette(package = 'TreeDist')}.

Other R packages implementing tree distance functions include:
\itemize{
\item \href{http://ape-package.ird.fr/}{ape}:
\itemize{
\item \code{cophenetic.phylo()}: Cophenetic distance
\item \code{dist.topo()}: Path (topological) distance, Robinson–Foulds distance.
}
\item \href{https://cran.r-project.org/package=phangorn}{phangorn}
\itemize{
\item \code{treedist()}: Path, Robinson–Foulds and approximate SPR distances.
}
\item \href{https://ms609.github.io/Quartet/}{Quartet}: Triplet and Quartet distances,
using the tqDist algorithm.
\item \href{https://ms609.github.io/TBRDist/}{TBRDist}: TBR and SPR distances on
unrooted trees, using the 'uspr; C library.
\item \href{https://cran.r-project.org/package=distory}{distory} (unmaintained):
Geodesic distance
}
}
\author{
\strong{Maintainer}: Martin R. Smith \email{martin.smith@durham.ac.uk} (\href{https://orcid.org/0000-0001-5660-1727}{ORCID}) [copyright holder, programmer]

Other contributors:
\itemize{
  \item Roy Jonker \email{roy_jonker@magiclogic.com} [programmer, copyright holder]
  \item Yong Yang \email{yongyanglink@gmail.com} [contributor, copyright holder]
  \item Yi Cao [contributor, copyright holder]
}

}
\keyword{internal}
